/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LabelIndexInfoResolver
implements IndexInfoResolver<Label> {
    private final boolean lowerCasing;

    public LabelIndexInfoResolver(boolean isLowerCasing) {
        this.lowerCasing = isLowerCasing;
    }

    public List<String> getIndexedValues(String rawValue) {
        ArrayList cleanLabels;
        String[] labels = StringUtils.split((String)rawValue, (String)" ");
        ArrayList arrayList = cleanLabels = labels != null ? Lists.newArrayListWithCapacity((int)labels.length) : Lists.newArrayList();
        if (labels != null) {
            for (String label : labels) {
                if (this.lowerCasing) {
                    cleanLabels.add(label.toLowerCase());
                    continue;
                }
                cleanLabels.add(label);
            }
            return cleanLabels;
        }
        return Collections.emptyList();
    }

    public List<String> getIndexedValues(Long rawValue) {
        return Lists.newArrayList((Object[])new String[]{rawValue.toString()});
    }

    public String getIndexedValue(Label label) {
        if (this.lowerCasing) {
            return label.getLabel().toLowerCase();
        }
        return label.getLabel();
    }
}

