/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.issue.changehistory.JqlChangeItemMapping;
import com.atlassian.jira.issue.index.ChangeHistoryFieldConfigurationManager;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.lucene.index.IndexReader;

public class HistoryFieldValueValidator {
    private static final Set<String> USER_FIELDS = ImmutableSet.of((Object)"assignee", (Object)"reporter");
    public static final String MSG_BAD_NAME_FROM_FUNCTION = "jira.jql.clause.no.value.for.name.from.function";
    private final SearchHandlerManager searchHandlerManager;
    private final JqlChangeItemMapping jqlChangeItemMapping;
    private final JqlOperandResolver operandResolver;
    private final ChangeHistoryFieldConfigurationManager configurationManager;
    private final SearchProviderFactory searchProviderFactory;
    private final I18nHelper.BeanFactory i18nFactory;
    private final UserKeyService userKeyService;

    public HistoryFieldValueValidator(SearchHandlerManager searchHandlerManager, JqlChangeItemMapping jqlChangeItemMapping, JqlOperandResolver operandResolver, ChangeHistoryFieldConfigurationManager configurationManager, SearchProviderFactory searchProviderFactory, I18nHelper.BeanFactory i18nFactory, UserKeyService userKeyService) {
        this.searchHandlerManager = searchHandlerManager;
        this.jqlChangeItemMapping = jqlChangeItemMapping;
        this.operandResolver = operandResolver;
        this.configurationManager = configurationManager;
        this.searchProviderFactory = searchProviderFactory;
        this.i18nFactory = i18nFactory;
        this.userKeyService = userKeyService;
    }

    private boolean stringValueExists(PossibleValuesHolder possibleValuesHolder, ApplicationUser searcher, String fieldName, String rawValue) {
        ClauseHandler clauseHandler;
        String valuePrefix = "";
        Collection clauseHandlers = this.searchHandlerManager.getClauseHandler(searcher, fieldName);
        if (clauseHandlers != null && clauseHandlers.size() == 1 && (clauseHandler = (ClauseHandler)clauseHandlers.iterator().next()) instanceof ValueGeneratingClauseHandler) {
            if (possibleValuesHolder.getCurrentValues() == null) {
                this.initCurrentValues(possibleValuesHolder, searcher, fieldName, "", clauseHandler);
            }
            if (possibleValuesHolder.getCurrentValues().contains(rawValue.toLowerCase())) {
                return true;
            }
            if (possibleValuesHolder.getHistoricalValues() == null) {
                this.initHistoricalValues(possibleValuesHolder, fieldName);
            }
            return possibleValuesHolder.getHistoricalValues().contains(rawValue.toLowerCase());
        }
        return false;
    }

    private void initHistoricalValues(PossibleValuesHolder possibleValuesHolder, String fieldName) {
        Set<String> possibleValuesSet = this.findAllPossibleFieldTerms(fieldName.toLowerCase());
        possibleValuesHolder.setHistoricalValues(possibleValuesSet);
    }

    private void initCurrentValues(PossibleValuesHolder possibleValuesHolder, ApplicationUser searcher, String fieldName, String valuePrefix, ClauseHandler clauseHandler) {
        ClauseValuesGenerator generator = ((ValueGeneratingClauseHandler)clauseHandler).getClauseValuesGenerator();
        ClauseValuesGenerator.Results generatorResults = generator.getPossibleValues(searcher, this.jqlChangeItemMapping.mapJqlClauseToFieldName(fieldName), valuePrefix, Integer.MAX_VALUE);
        List list = generatorResults.getResults();
        HashSet possibleValues = Sets.newHashSetWithExpectedSize((int)list.size());
        for (ClauseValuesGenerator.Result result : list) {
            possibleValues.add(result.getValue().toLowerCase());
        }
        possibleValuesHolder.setCurrentValues(possibleValues);
    }

    private Set<String> findAllPossibleFieldTerms(String fieldName) {
        if (USER_FIELDS.contains(fieldName)) {
            return this.convertUserkeysToUsernames(this.findAllPossibleFieldTerms(fieldName, "ch_oldvalue", "ch_newvalue"));
        }
        return this.findAllPossibleFieldTerms(fieldName, "ch_from", "ch_to");
    }

    private Set<String> findAllPossibleFieldTerms(String fieldName, String oldKey, String newKey) {
        HashSet values = Sets.newHashSet();
        JiraLuceneFieldFinder luceneFieldFinder = JiraLuceneFieldFinder.getInstance();
        try {
            IndexReader reader = this.searchProviderFactory.getSearcher("changes").getIndexReader();
            List oldValues = luceneFieldFinder.getTermValuesForField(reader, fieldName + "." + oldKey);
            List newValues = luceneFieldFinder.getTermValuesForField(reader, fieldName + "." + newKey);
            values.addAll(oldValues);
            values.addAll(newValues);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return HistoryFieldValueValidator.stripProtocol(values);
    }

    private Set<String> convertUserkeysToUsernames(Set<String> keys) {
        HashSet usernames = Sets.newHashSetWithExpectedSize((int)keys.size());
        for (String key : keys) {
            String username = this.userKeyService.getUsernameForKey(key);
            if (username == null) continue;
            usernames.add(username);
        }
        return usernames;
    }

    private static Set<String> stripProtocol(Set<String> values) {
        HashSet newValues = Sets.newHashSetWithExpectedSize((int)values.size());
        int index = "ch-".length();
        for (String value : values) {
            newValues.add(value.substring(index));
        }
        return newValues;
    }

    @Nonnull
    public MessageSet validateValues(ApplicationUser searcher, String fieldName, List<QueryLiteral> rawValues) {
        PossibleValuesHolder possibleValuesHolder = new PossibleValuesHolder();
        MessageSetImpl messages = new MessageSetImpl();
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.getStringValue() != null) {
                this.validateStringValue(searcher, fieldName, possibleValuesHolder, (MessageSet)messages, rawValue);
                continue;
            }
            if (rawValue.getLongValue() == null) continue;
            if (this.stringValueExists(possibleValuesHolder, searcher, fieldName, rawValue.getLongValue().toString())) {
                return messages;
            }
            this.validateLongValue(searcher, fieldName, (MessageSet)messages, rawValue);
        }
        return messages;
    }

    private void validateLongValue(ApplicationUser searcher, String fieldName, MessageSet messages, QueryLiteral rawValue) {
        if (this.configurationManager.supportsIdSearching(fieldName.toLowerCase())) {
            this.validateIdValue(searcher, fieldName, messages, rawValue);
        } else if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
            messages.addErrorMessage(this.getI18n(searcher).getText(MSG_BAD_NAME_FROM_FUNCTION, rawValue.getSourceOperand().getName(), fieldName));
        } else {
            messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.history.clause.not.string", rawValue.getSourceOperand().getName(), fieldName));
        }
    }

    private void validateIdValue(ApplicationUser searcher, String fieldName, MessageSet messages, QueryLiteral rawValue) {
        if (!this.longValueExists(fieldName, rawValue.getLongValue())) {
            if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                messages.addErrorMessage(this.getI18n(searcher).getText(MSG_BAD_NAME_FROM_FUNCTION, rawValue.getSourceOperand().getName(), fieldName));
            } else {
                messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.id", fieldName, rawValue.getLongValue().toString()));
            }
        }
    }

    private void validateStringValue(ApplicationUser searcher, String fieldName, PossibleValuesHolder possibleValuesHolder, MessageSet messages, QueryLiteral rawValue) {
        if (!this.stringValueExists(possibleValuesHolder, searcher, fieldName, rawValue.getStringValue())) {
            if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                messages.addErrorMessage(this.getI18n(searcher).getText(MSG_BAD_NAME_FROM_FUNCTION, rawValue.getSourceOperand().getName(), fieldName));
            } else {
                messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name", fieldName, rawValue.getStringValue()));
            }
        }
    }

    private boolean longValueExists(String fieldName, Long longValue) {
        NameResolver resolver = this.configurationManager.getNameResolver(fieldName.toLowerCase());
        return resolver.idExists(longValue);
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    static class PossibleValuesHolder {
        private Set<String> currentValues;
        private Set<String> historicalValues;

        PossibleValuesHolder() {
        }

        private Set<String> getCurrentValues() {
            return this.currentValues;
        }

        private void setCurrentValues(Set<String> currentValues) {
            this.currentValues = currentValues;
        }

        private Set<String> getHistoricalValues() {
            return this.historicalValues;
        }

        private void setHistoricalValues(Set<String> historicalValues) {
            this.historicalValues = historicalValues;
        }
    }
}

