/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import java.util.Optional;

class ProjectValuesExistValidator
extends ValuesExistValidator {
    private final ProjectIndexInfoResolver projectIndexInfoResolver;
    private final ProjectManager projectManager;
    private final InternalProjectPermissionHelper projectPermissionHelper;

    ProjectValuesExistValidator(JqlOperandResolver operandResolver, ProjectIndexInfoResolver projectIndexInfoResolver, ProjectManager projectManager, InternalProjectPermissionHelper projectPermissionHelper, I18nHelper.BeanFactory beanFactory) {
        super(operandResolver, beanFactory);
        this.projectIndexInfoResolver = (ProjectIndexInfoResolver)Assertions.notNull((String)"projectIndexInfoResolver", (Object)projectIndexInfoResolver);
        this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
        this.projectPermissionHelper = (InternalProjectPermissionHelper)Assertions.notNull((String)"projectPermissionHelper", (Object)projectPermissionHelper);
    }

    boolean stringValueExists(ApplicationUser searcher, String value) {
        List<String> ids = this.projectIndexInfoResolver.getIndexedValues(value);
        return this.projectExists(searcher, ids);
    }

    boolean longValueExist(ApplicationUser searcher, Long value) {
        List<String> ids = this.projectIndexInfoResolver.getIndexedValues(value);
        return this.projectExists(searcher, ids);
    }

    boolean projectExists(ApplicationUser searcher, List<String> ids) {
        for (String sid : ids) {
            boolean canUserSeeTheProject = Optional.ofNullable(this.convertToLong(sid)).map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).map(p -> this.projectPermissionHelper.canUserBrowseProject((Project)p, searcher)).orElse(false);
            if (!canUserSeeTheProject) continue;
            return true;
        }
        return false;
    }

    private Long convertToLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

