/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.extras.decoder.api.LicenseDecoder;
import com.atlassian.extras.decoder.api.LicenseVerificationException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.license.ForgedLicenseDetector;

public class CachingForgedLicenseDetectorImpl
implements ForgedLicenseDetector,
Startable {
    private final LicenseDecoder licenseDecoder;
    private final CacheManager cacheManager;
    private Cache<String, Boolean> cache;

    public CachingForgedLicenseDetectorImpl(CacheManager cacheManager, LicenseDecoder licenseDecoder) {
        this.licenseDecoder = licenseDecoder;
        this.cacheManager = cacheManager;
    }

    public void start() {
        this.cache = this.cacheManager.getCache(CachingForgedLicenseDetectorImpl.class.getName() + ".cache", this::isForged);
    }

    @Override
    public boolean isLicenseForged(String licenseString) {
        return (Boolean)this.cache.get((Object)licenseString);
    }

    private boolean isForged(String licenseString) {
        try {
            this.licenseDecoder.decode(licenseString);
            return false;
        }
        catch (LicenseVerificationException e) {
            return true;
        }
    }
}

