/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseBannerHelper;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.ExperienceOverride;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.soy.renderer.SoyException;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseBannerHelperImpl
implements LicenseBannerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseBannerHelperImpl.class);
    static final String EXPIRY_KEY = "license.expiry.remindme";
    static final String MAINTENANCE_KEY = "license.maintenance.remindme";
    private static final int EARLIEST_EXPIRY_ERROR_FROM_EXPIRY = 1;
    private static final int EARLIEST_EXPIRY_WARNING_FROM_EXPIRY = 90;
    private static final String LINK_MANAGE_APPLICATION = "/plugins/servlet/applications/versions-licenses";
    private final JiraAuthenticationContext context;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserPropertyManager propertyManager;
    private final JiraLicenseManager jiraLicenseManager;
    private final SoyTemplateRendererProvider rendererProvider;
    private final BaseUrl baseUrl;
    private final FeatureManager featureManager;

    public LicenseBannerHelperImpl(JiraAuthenticationContext context, GlobalPermissionManager globalPermissionManager, UserPropertyManager propertyManager, JiraLicenseManager jiraLicenseManager, SoyTemplateRendererProvider rendererProvider, BaseUrl baseUrl, FeatureManager featureManager) {
        this.context = context;
        this.globalPermissionManager = globalPermissionManager;
        this.propertyManager = propertyManager;
        this.jiraLicenseManager = jiraLicenseManager;
        this.rendererProvider = rendererProvider;
        this.baseUrl = baseUrl;
        this.featureManager = featureManager;
    }

    @Override
    @Nonnull
    public String getExpiryBanner() {
        if (this.canViewLicenseInfo()) {
            return "";
        }
        ExpirationStateAccumulator subscriptionChecker = this.getEarliestExpiringLicenseChecker(1);
        if (subscriptionChecker.isExpiring() || subscriptionChecker.getDaysToExpire() <= 1) {
            return this.renderExpiryBanner(subscriptionChecker);
        }
        if (subscriptionChecker.getDaysToExpire() > 90) {
            this.clearHideUntilExpiry();
        }
        return "";
    }

    @Override
    public boolean canViewLicenseInfo() {
        return !this.havePermission() || !this.jiraLicenseManager.isLicenseSet();
    }

    @Override
    @Nonnull
    public String getLicenseFlag() {
        if (this.canViewLicenseInfo()) {
            return "";
        }
        ExpirationStateAccumulator subscriptionChecker = this.getEarliestExpiringLicenseChecker(90);
        if (subscriptionChecker.isExpiring() && subscriptionChecker.getDaysToExpire() > 1) {
            return this.renderExpiryFlag(subscriptionChecker);
        }
        ExpirationStateAccumulator maintenanceChecker = this.getEarliestMaintenanceExpiringLicenseChecker();
        if (this.shouldNotDisplayMaintenanceFlag(subscriptionChecker, maintenanceChecker)) {
            if (maintenanceChecker.getDaysToExpire() > 90) {
                this.clearHideUtilMaintenance();
            }
            return "";
        }
        return this.renderMaintenanceFlag(maintenanceChecker);
    }

    private boolean shouldNotDisplayMaintenanceFlag(ExpirationStateAccumulator subscriptionChecker, ExpirationStateAccumulator maintenanceChecker) {
        if (this.featureManager.isEnabled("never.display.maintenance.flag")) {
            return true;
        }
        return !maintenanceChecker.isExpiring() || subscriptionChecker.getDaysToExpire() <= 1 && maintenanceChecker.getApplicationDescription().equals(subscriptionChecker.getApplicationDescription());
    }

    private ExpirationStateAccumulator getEarliestExpiringLicenseChecker(int maxDaysFromExpiry) {
        int daysFromExpiry = Math.min(this.getHideUntilExpiry(), maxDaysFromExpiry);
        EarliestExpiringLicenseChecker licenseChecker = new EarliestExpiringLicenseChecker(daysFromExpiry, this.jiraLicenseManager.getLicenses());
        return licenseChecker.getSubscriptionExpiringLicense();
    }

    private ExpirationStateAccumulator getEarliestMaintenanceExpiringLicenseChecker() {
        int daysFromExpiry = Math.min(this.getHideUntilMaintenance(), 90);
        EarliestExpiringLicenseChecker licenseChecker = new EarliestExpiringLicenseChecker(daysFromExpiry, this.jiraLicenseManager.getLicenses());
        return licenseChecker.getMaintenanceExpiringLicense();
    }

    @Override
    public void remindMeLater() {
        if (!this.havePermission()) {
            return;
        }
        if (!this.jiraLicenseManager.isLicenseSet()) {
            this.clearHideUntilExpiry();
            this.clearHideUtilMaintenance();
            return;
        }
        EarliestExpiringLicenseChecker licenseChecker = new EarliestExpiringLicenseChecker(90, this.jiraLicenseManager.getLicenses());
        ExpirationStateAccumulator subscriptionChecker = licenseChecker.getSubscriptionExpiringLicense();
        ExpirationStateAccumulator maintenanceChecker = licenseChecker.getMaintenanceExpiringLicense();
        if (!subscriptionChecker.isExpiring()) {
            this.clearHideUntilExpiry();
            int daysToMaintenanceExpiry = maintenanceChecker.getDaysToExpire();
            if (maintenanceChecker.isExpiring()) {
                if (daysToMaintenanceExpiry <= -7) {
                    this.setHideUtilMaintenance(Integer.MIN_VALUE);
                } else if (daysToMaintenanceExpiry <= 0) {
                    this.setHideUtilMaintenance(daysToMaintenanceExpiry - 7);
                } else if (daysToMaintenanceExpiry <= 1) {
                    this.setHideUtilMaintenance(0);
                } else if (daysToMaintenanceExpiry <= 7) {
                    this.setHideUtilMaintenance(1);
                } else if (daysToMaintenanceExpiry <= 15) {
                    this.setHideUtilMaintenance(7);
                } else if (daysToMaintenanceExpiry <= 30) {
                    this.setHideUtilMaintenance(15);
                } else if (daysToMaintenanceExpiry <= 45) {
                    this.setHideUtilMaintenance(30);
                } else {
                    this.setHideUtilMaintenance(45);
                }
            } else {
                this.clearHideUtilMaintenance();
            }
        } else {
            int daysToLicenseExpiry = licenseChecker.getSubscriptionExpiringLicense().getDaysToExpire();
            if (daysToLicenseExpiry <= 1) {
                this.clearHideUntilExpiry();
            } else if (daysToLicenseExpiry <= 7) {
                this.setHideUtilExpiry(1);
            } else if (daysToLicenseExpiry <= 15) {
                this.setHideUtilExpiry(7);
            } else if (daysToLicenseExpiry <= 30) {
                this.setHideUtilExpiry(15);
            } else if (daysToLicenseExpiry <= 45) {
                this.setHideUtilExpiry(30);
            } else {
                this.setHideUtilExpiry(45);
            }
        }
    }

    @Override
    public void clearRemindMe() {
        if (!this.havePermission()) {
            return;
        }
        this.clearHideUntilExpiry();
        this.clearHideUtilMaintenance();
    }

    private String renderNotification(String templateToRender, ExpirationStateAccumulator licenseChecker, String experienceId) {
        if (this.isOverwritten(experienceId)) {
            return "";
        }
        try {
            return this.rendererProvider.getRenderer().render("jira.webresources:soy-templates", templateToRender, (Map)ImmutableMap.of((Object)"days", (Object)licenseChecker.getDaysToExpire(), (Object)"mac", (Object)this.getMacUrl(), (Object)"licenseId", (Object)licenseChecker.getApplicationDescription(), (Object)"isEvaluation", (Object)licenseChecker.isEvaluation()));
        }
        catch (SoyException e) {
            LOG.debug("Unable to render banner.", (Throwable)e);
            return "";
        }
    }

    @Nonnull
    private String renderExpiryBanner(ExpirationStateAccumulator licenseChecker) {
        String templateToRender = licenseChecker.isMultipleExpiring() ? "JIRA.Templates.LicenseBanner.expiryBannerMultiple" : "JIRA.Templates.LicenseBanner.expiryBanner";
        return this.renderNotification(templateToRender, licenseChecker, "license-expiry-banner");
    }

    private String renderMaintenanceFlag(ExpirationStateAccumulator licenseChecker) {
        String templateToRender = licenseChecker.isMultipleExpiring() ? "JIRA.Templates.LicenseBanner.maintenanceFlagMultiple" : "JIRA.Templates.LicenseBanner.maintenanceFlag";
        return this.renderNotification(templateToRender, licenseChecker, "license-maintenance-flag");
    }

    private String renderExpiryFlag(ExpirationStateAccumulator licenseChecker) {
        String templateToRender = licenseChecker.isMultipleExpiring() ? "JIRA.Templates.LicenseBanner.expiryFlagMultiple" : "JIRA.Templates.LicenseBanner.expiryFlag";
        return this.renderNotification(templateToRender, licenseChecker, "license-expiry-flag");
    }

    private String getMacUrl() {
        return this.baseUrl.getBaseUrl() + LINK_MANAGE_APPLICATION;
    }

    private void setHideUtilExpiry(int days) {
        this.setRemindMeDays(days, EXPIRY_KEY);
        this.setHideUtilMaintenance(days);
    }

    private void setHideUtilMaintenance(int days) {
        this.setRemindMeDays(days, MAINTENANCE_KEY);
    }

    private void setRemindMeDays(int days, String key) {
        PropertySet propertySet = this.getPropertySet();
        propertySet.setInt(key, days);
    }

    private void clearHideUntilExpiry() {
        this.clearRemindMeDays(EXPIRY_KEY);
    }

    private void clearHideUtilMaintenance() {
        this.clearRemindMeDays(MAINTENANCE_KEY);
    }

    private void clearRemindMeDays(String key) {
        PropertySet propertySet = this.getPropertySet();
        if (propertySet != null && propertySet.exists(key)) {
            propertySet.remove(key);
        }
    }

    private int getHideUntilMaintenance() {
        return this.getRemindMeDays(MAINTENANCE_KEY);
    }

    private int getHideUntilExpiry() {
        return this.getRemindMeDays(EXPIRY_KEY);
    }

    private int getRemindMeDays(String key) {
        PropertySet propertySet = this.getPropertySet();
        if (propertySet != null && propertySet.exists(key)) {
            return propertySet.getInt(key);
        }
        return Integer.MAX_VALUE;
    }

    private PropertySet getPropertySet() {
        return this.propertyManager.getPropertySet(this.context.getUser());
    }

    private boolean havePermission() {
        ApplicationUser user = this.context.getUser();
        return !Users.isAnonymous((ApplicationUser)user) && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private boolean isOverwritten(String experienceId) {
        return (Boolean)SafePluginPointAccess.call(() -> {
            ExperienceOverride experienceOverride = (ExperienceOverride)ComponentAccessor.getOSGiComponentInstanceOfType(ExperienceOverride.class);
            return experienceOverride != null && experienceOverride.hasOverride(this.context.getLoggedInUser(), experienceId, this.context.getLocale());
        }).getOrElse((Object)false);
    }

    private static abstract class ExpirationStateAccumulator {
        private int daysToExpire = Integer.MAX_VALUE;
        private String applicationDescription = "";
        private boolean isEvaluation = false;
        private int expiringApps = 0;
        int notificationPeriod = 90;

        ExpirationStateAccumulator(int notificationPeriod) {
            this.notificationPeriod = notificationPeriod;
        }

        boolean checkLicense(LicenseDetails license) {
            if (this.ignoreLicense(license)) {
                return false;
            }
            int thisLicenseDaysToExpiry = this.getDaysToExpireFrom(license);
            this.daysToExpire = Math.min(thisLicenseDaysToExpiry, this.daysToExpire);
            if (this.notificationPeriod >= thisLicenseDaysToExpiry) {
                this.expiringApps += license.getLicensedApplications().getKeys().size();
                this.applicationDescription = license.getApplicationDescription();
                this.isEvaluation = license.isEvaluation();
                return true;
            }
            return false;
        }

        public int getDaysToExpire() {
            return this.daysToExpire;
        }

        public String getApplicationDescription() {
            return this.applicationDescription;
        }

        public boolean isEvaluation() {
            return this.isEvaluation;
        }

        public boolean isMultipleExpiring() {
            return this.expiringApps > 1;
        }

        public boolean isExpiring() {
            return this.expiringApps > 0;
        }

        private boolean ignoreLicense(LicenseDetails license) {
            return license.isEvaluation() && license.getDaysToLicenseExpiry() > 15;
        }

        abstract int getDaysToExpireFrom(@Nonnull LicenseDetails var1);
    }

    private static class EarliestExpiringLicenseChecker {
        ExpirationStateAccumulator subscriptionExpiringLicense = null;
        ExpirationStateAccumulator maintenanceExpiringLicense = null;

        EarliestExpiringLicenseChecker(int notificationPeriod, Iterable<LicenseDetails> theLicenses) {
            this.subscriptionExpiringLicense = new ExpirationStateAccumulator(notificationPeriod){

                @Override
                int getDaysToExpireFrom(@Nonnull LicenseDetails license) {
                    return license.getDaysToLicenseExpiry();
                }
            };
            this.maintenanceExpiringLicense = new ExpirationStateAccumulator(notificationPeriod){

                @Override
                int getDaysToExpireFrom(@Nonnull LicenseDetails license) {
                    return license.getDaysToMaintenanceExpiry();
                }
            };
            for (LicenseDetails license : theLicenses) {
                this.checkLicense(license);
            }
        }

        public ExpirationStateAccumulator getSubscriptionExpiringLicense() {
            return this.subscriptionExpiringLicense;
        }

        public ExpirationStateAccumulator getMaintenanceExpiringLicense() {
            return this.maintenanceExpiringLicense;
        }

        private boolean checkLicense(LicenseDetails license) {
            boolean result = this.subscriptionExpiringLicense.checkLicense(license);
            return result |= this.maintenanceExpiringLicense.checkLicense(license);
        }
    }
}

