/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseMaintenancePredicate;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Option;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public final class LicenseMaintenancePredicateImpl
implements LicenseMaintenancePredicate {
    private final ApplicationManager applicationManager;
    private final BuildUtilsInfo info;

    @Inject
    public LicenseMaintenancePredicateImpl(ApplicationManager applicationManager, BuildUtilsInfo info) {
        this.applicationManager = (ApplicationManager)Assertions.notNull((String)"applicationManager", (Object)applicationManager);
        this.info = (BuildUtilsInfo)Assertions.notNull((String)"info", (Object)info);
    }

    @Override
    public boolean test(@Nonnull LicenseDetails details) {
        Assertions.notNull((String)"details", (Object)details);
        Set licensedApplicationKeys = details.getLicensedApplications().getKeys();
        for (ApplicationKey key : licensedApplicationKeys) {
            Date buildDate;
            Option appOption = Option.option((Object)((Application)this.applicationManager.getApplication(key).getOrNull()));
            if (!appOption.isDefined() || details.isMaintenanceValidForBuildDate(buildDate = Date.from(((Application)appOption.get()).buildZonedDate().toInstant()))) continue;
            return false;
        }
        return details.isMaintenanceValidForBuildDate(this.info.getCurrentBuildDate());
    }
}

