/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.cluster.logging.LoggingManager;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.mail.LogPrintStream;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import java.io.PrintStream;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.LoggerFactory;

public class DefaultMailLoggingManager
implements MailLoggingManager {
    private static final Logger outgoingMailLogger = LogManager.getLogger((String)"com.atlassian.mail.outgoing");
    private static final Logger incomingMailLogger = LogManager.getLogger((String)"com.atlassian.mail.incoming");
    private final LoggingManager loggingManager;

    public DefaultMailLoggingManager(MailServerManager mailServerManager, LoggingManager loggingManager) {
        this.loggingManager = loggingManager;
        mailServerManager.setMailServerConfigurationHandler(this::configureLogging);
    }

    public void configureLogging(MailServer mailServer) {
        if (mailServer instanceof SMTPMailServer) {
            outgoingMailLogger.trace("Configuring SMTPMailServer [" + mailServer + "]");
            SMTPMailServer smtpMailServer = (SMTPMailServer)mailServer;
            smtpMailServer.setDebugStream((PrintStream)new PasswordFilteringLogPrintStream(mailServer.getPassword(), outgoingMailLogger));
            mailServer.setDebug(this.getOutgoingMailLoggingLevel() == org.apache.log4j.Level.DEBUG);
            mailServer.setLogger(LoggerFactory.getLogger((String)outgoingMailLogger.getName()));
        } else if (mailServer instanceof PopMailServer) {
            incomingMailLogger.trace("Configuring PopMailServer [" + mailServer + "]");
            mailServer.setDebug(this.getIncomingMailLoggingLevel() == org.apache.log4j.Level.DEBUG);
            mailServer.setDebugStream((PrintStream)new PasswordFilteringLogPrintStream(mailServer.getPassword(), incomingMailLogger));
            mailServer.setLogger(LoggerFactory.getLogger((String)incomingMailLogger.getName()));
        }
        ThreadContext.put((String)"jira.mailserver", (String)mailServer.getName());
    }

    public org.apache.log4j.Level getOutgoingMailLoggingLevel() {
        return org.apache.log4j.Level.toLevel((String)outgoingMailLogger.getLevel().name());
    }

    public org.apache.log4j.Level getIncomingMailLoggingLevel() {
        return org.apache.log4j.Level.toLevel((String)incomingMailLogger.getLevel().name());
    }

    public void setOutgoingMailLoggingLevel(org.apache.log4j.Level loggingLevel) {
        Assertions.notNull((String)"LoggingLevel cannot be null", (Object)loggingLevel);
        this.loggingManager.setLogLevel(outgoingMailLogger, Level.getLevel((String)loggingLevel.toString()));
    }

    public void setIncomingMailLoggingLevel(org.apache.log4j.Level loggingLevel) {
        Assertions.notNull((String)"LoggingLevel cannot be null", (Object)loggingLevel);
        this.loggingManager.setLogLevel(incomingMailLogger, Level.getLevel((String)loggingLevel.toString()));
    }

    public org.apache.log4j.Logger getOutgoingMailLogger() {
        return org.apache.log4j.Logger.getLogger((String)outgoingMailLogger.getName());
    }

    public org.apache.log4j.Logger getIncomingMailLogger() {
        return org.apache.log4j.Logger.getLogger((String)incomingMailLogger.getName());
    }

    public org.apache.log4j.Logger getIncomingMailChildLogger(String subname) {
        String loggerName = incomingMailLogger.getName() + "." + subname;
        return org.apache.log4j.Logger.getLogger((String)loggerName);
    }

    public boolean isMailRelatedLogger(org.apache.log4j.Logger logger) {
        String name = logger.getName();
        return name != null && name.startsWith("com.atlassian.mail");
    }

    static class PasswordFilteringLogPrintStream
    extends LogPrintStream {
        private final String password;
        private final Pattern replacePattern;

        public PasswordFilteringLogPrintStream(String password, Logger logger) {
            super(logger, Level.DEBUG);
            this.password = password;
            this.replacePattern = password != null ? Pattern.compile("(.*PASS.*?[ \"]|.*LOGIN.*?[ \"])" + Pattern.quote(password)) : null;
        }

        @Override
        public String processLine(String s) {
            if (s != null && this.password != null && this.password.length() > 2) {
                s = this.replacePattern.matcher(s).replaceAll("$1<hidden password>");
            }
            return s;
        }
    }
}

