/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DefaultTemplateContext
implements TemplateContext {
    private final Locale locale;
    private final WebResourceUrlProvider resourceUrlProvider;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory beanFactory;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public DefaultTemplateContext(Locale locale, WebResourceUrlProvider resourceUrlProvider, ApplicationProperties applicationProperties, I18nHelper.BeanFactory beanFactory, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.locale = locale;
        this.resourceUrlProvider = resourceUrlProvider;
        this.applicationProperties = applicationProperties;
        this.beanFactory = beanFactory;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Override
    public Map<String, Object> getTemplateParams() {
        I18nHelper i18nHelper = this.beanFactory.getInstance(this.locale);
        HashMap templateParams = Maps.newHashMap();
        templateParams.put("i18n", i18nHelper);
        OutlookDate formatter = new OutlookDate(this.locale);
        templateParams.put("dateformatter", formatter);
        templateParams.put("datetimeformatter", this.dateTimeFormatterFactory.formatter().withLocale(this.locale));
        LookAndFeelBean landf = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        templateParams.put("lfbean", landf);
        templateParams.put("baseurl", this.applicationProperties.getString("jira.baseurl"));
        Object jiraLogo = landf.getLogoUrl();
        if (jiraLogo != null && !((String)jiraLogo).startsWith("http://") && !((String)jiraLogo).startsWith("https://")) {
            jiraLogo = this.resourceUrlProvider.getStaticResourcePrefix(UrlMode.ABSOLUTE) + (String)jiraLogo;
        }
        templateParams.put("jiraLogoUrl", jiraLogo);
        return templateParams;
    }
}

