/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.ipd.mailqueue.ErrorMailQueueItemsAddedCounter;
import com.atlassian.jira.ipd.mailqueue.MailJobRunningMetric;
import com.atlassian.jira.ipd.mailqueue.MailQueueItemsAddedCounter;
import com.atlassian.jira.ipd.mailqueue.MailQueueItemsProcessedCounter;
import com.atlassian.jira.mail.CountingMailQueueItemWrapper;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueImpl;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.util.Queue;

public class JiraMailQueue
implements MailQueue {
    private final MailQueue delegate;
    private final MailQueueItemsAddedCounter mailMonitoring;
    private final ErrorMailQueueItemsAddedCounter errorMailQueueMonitoring;
    private final MailQueueItemsProcessedCounter mailQueueItemsProcessedCounter;
    private final BaseUrl baseUrl;
    private final MailJobRunningMetric mailJobRunningMetric;

    public JiraMailQueue(MailQueueItemsAddedCounter mailMonitoring, ErrorMailQueueItemsAddedCounter errorMailQueueMonitoring, MailQueueItemsProcessedCounter mailQueueItemsProcessedCounter, BaseUrl baseUrl, MailJobRunningMetric mailJobRunningMetric) {
        this((MailQueue)new MailQueueImpl(), mailMonitoring, errorMailQueueMonitoring, mailQueueItemsProcessedCounter, baseUrl, mailJobRunningMetric);
    }

    @VisibleForTesting
    JiraMailQueue(MailQueue delegate, MailQueueItemsAddedCounter mailMonitoring, ErrorMailQueueItemsAddedCounter errorMailQueueMonitoring, MailQueueItemsProcessedCounter mailQueueItemsProcessedCounter, BaseUrl baseUrl, MailJobRunningMetric mailJobRunningMetric) {
        this.delegate = delegate;
        this.mailMonitoring = mailMonitoring;
        this.errorMailQueueMonitoring = errorMailQueueMonitoring;
        this.mailQueueItemsProcessedCounter = mailQueueItemsProcessedCounter;
        this.baseUrl = baseUrl;
        this.mailJobRunningMetric = mailJobRunningMetric;
    }

    public void sendBuffer() {
        this.sendAndUpdateIpdMetric(() -> ((MailQueue)this.delegate).sendBuffer());
    }

    public void sendBufferBlocking() {
        this.sendAndUpdateIpdMetric(() -> ((MailQueue)this.delegate).sendBufferBlocking());
    }

    public int size() {
        return this.delegate.size();
    }

    public int errorSize() {
        return this.delegate.errorSize();
    }

    public void addItem(MailQueueItem item) {
        this.delegate.addItem(this.wrap(item));
        this.mailMonitoring.incrementCounter();
    }

    public void addErrorItem(MailQueueItem item) {
        this.delegate.addErrorItem(item);
    }

    public Queue<MailQueueItem> getQueue() {
        return this.delegate.getQueue();
    }

    public Queue<MailQueueItem> getErrorQueue() {
        return this.delegate.getErrorQueue();
    }

    public boolean isSending() {
        return this.delegate.isSending();
    }

    public Timestamp getSendingStarted() {
        return this.delegate.getSendingStarted();
    }

    public Timestamp getLastSendingAttempt() {
        return this.delegate.getLastSendingAttempt();
    }

    public void emptyErrorQueue() {
        this.errorMailQueueMonitoring.recordEmptyErrorQueue(this.delegate.errorSize());
        this.delegate.emptyErrorQueue();
    }

    public void resendErrorQueue() {
        this.errorMailQueueMonitoring.recordEmptyErrorQueue(this.delegate.errorSize());
        this.delegate.resendErrorQueue();
    }

    public MailQueueItem getItemBeingSent() {
        return this.delegate.getItemBeingSent();
    }

    public void unstickQueue() {
        this.delegate.unstickQueue();
    }

    private MailQueueItem wrap(MailQueueItem item) {
        return new CountingMailQueueItemWrapper(item, this.mailQueueItemsProcessedCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndUpdateIpdMetric(Runnable sendingFunction) {
        long valueToReport;
        try {
            this.mailJobRunningMetric.update(1L);
            this.baseUrl.runWithStaticBaseUrl(null, nullValue -> {
                sendingFunction.run();
                return null;
            });
            valueToReport = this.isSending() ? 1L : 0L;
        }
        catch (Throwable throwable) {
            long valueToReport2 = this.isSending() ? 1L : 0L;
            this.mailJobRunningMetric.update(valueToReport2);
            throw throwable;
        }
        this.mailJobRunningMetric.update(valueToReport);
    }
}

