/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.threading.EmailHeaderBuilders;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.mail.MailUtils;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class JiraMailUtils {
    private static final String JIRA_HOST_NAME_DEFAULT = "Atlassian.JIRA";

    @Deprecated
    public static boolean isHasMailServer() {
        return ComponentAccessor.getMailServerManager().getDefaultSMTPMailServer() != null;
    }

    static String getProjectEmailFromIssue(Issue issue) {
        return issue.getProjectObject().getEmail();
    }

    public static String getFromNameForUser(ApplicationUser sender) {
        String email;
        String name;
        String from = ComponentAccessor.getApplicationProperties().getDefaultBackedString("jira.email.fromheader.format");
        if (from == null) {
            return null;
        }
        if (Users.isAnonymous((ApplicationUser)sender)) {
            name = "Anonymous";
        } else {
            try {
                String fullName = sender.getDisplayName();
                name = StringUtils.isBlank((CharSequence)fullName) ? sender.getName() : fullName;
            }
            catch (Exception exception) {
                try {
                    name = sender.getName();
                }
                catch (Exception exception2) {
                    name = "";
                }
            }
        }
        try {
            email = sender != null ? sender.getEmailAddress() : "";
        }
        catch (Exception exception) {
            email = "";
        }
        String hostname = sender != null && email != null ? email.substring(email.indexOf("@") + 1) : "";
        from = StringUtils.replace((String)from, (String)"${fullname}", (String)name);
        from = StringUtils.replace((String)from, (String)"${email}", (String)email);
        from = StringUtils.replace((String)from, (String)"${email.hostname}", (String)hostname);
        return from;
    }

    private static String getJiraHostname() {
        return JIRA_HOST_NAME_DEFAULT;
    }

    @Nonnull
    public static String getMessageId(Issue issue, int sequence) {
        String hostname = JiraMailUtils.getJiraHostname();
        return new EmailHeaderBuilders.MessageIdBuilder(issue).setSequence(sequence).setHostName(hostname).build();
    }

    @Nonnull
    public static List<String> getReplyToIds(Issue issue) {
        String hostname = JiraMailUtils.getJiraHostname();
        String parentMessageId = new EmailHeaderBuilders.InReplyToHeaderBuilder(issue).setHostName(hostname).build();
        String parentMessageIdOld = new EmailHeaderBuilders.InReplyToHeaderBuilder(issue).setDropMillis(false).setHostName(MailUtils.getLocalHostName()).build();
        return Arrays.asList(parentMessageId, parentMessageIdOld);
    }

    public static boolean isAvatarUrl(URI uri) {
        if (null == uri) {
            return false;
        }
        return Option.option((Object)uri.getPath()).exists(path -> path.endsWith("/secure/viewavatar"));
    }
}

