/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.mail.queue.SingleMailQueueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

abstract class NotificationRecipientProcessor {
    private final Collection<NotificationRecipient> recipients;

    NotificationRecipientProcessor(Collection<NotificationRecipient> recipients) {
        this.recipients = recipients;
    }

    public Collection<SingleMailQueueItem> evaluateEmails() {
        ArrayList<SingleMailQueueItem> result = new ArrayList<SingleMailQueueItem>(this.recipients.size());
        for (NotificationRecipient recipient : this.recipients) {
            try {
                this.evaluateEmailForRecipient(recipient).ifPresent(result::add);
            }
            catch (Exception ex) {
                this.handleException(recipient, ex);
            }
        }
        return result;
    }

    abstract Optional<SingleMailQueueItem> evaluateEmailForRecipient(NotificationRecipient var1) throws Exception;

    abstract void handleException(NotificationRecipient var1, Exception var2);
}

