/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.GenericIssueWrapper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.JiraKeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateIssue
extends GenericIssueWrapper {
    private static final Logger log = LoggerFactory.getLogger(TemplateIssue.class);
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final CustomFieldManager customFieldManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    private AggregateTimeTrackingBean aggregateBean;

    public TemplateIssue(Issue issue, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, CustomFieldManager customFieldManager, JiraDurationUtils jiraDurationUtils, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory) {
        super(issue);
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.customFieldManager = customFieldManager;
        this.jiraDurationUtils = jiraDurationUtils;
        this.aggregateTimeTrackingCalculatorFactory = aggregateTimeTrackingCalculatorFactory;
    }

    public String getHtmlDescription() {
        Issue issue = this.getDelegate();
        try {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem("description");
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            String renderedContent = this.rendererManager.getRenderedContent(rendererType, issue.getDescription(), issue.getIssueRenderContext());
            return renderedContent.replaceAll("<p>", "<p style='margin-top:0;margin-bottom:10px;'>");
        }
        catch (Exception e) {
            log.warn("Unable to produce rendered version of the description for the issue " + issue.getKey(), (Throwable)e);
            return JiraKeyUtils.linkBugKeys((String)issue.getDescription());
        }
    }

    public String getHtmlEnvironment() {
        Issue issue = this.getDelegate();
        try {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem("environment");
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            String renderedContent = this.rendererManager.getRenderedContent(rendererType, issue.getEnvironment(), issue.getIssueRenderContext());
            return renderedContent.replaceAll("<p>", "<p style='margin-top:0;margin-bottom:10px;'>");
        }
        catch (Exception e) {
            log.warn("Unable to produce rendered version of the environment for the issue " + issue.getKey(), (Throwable)e);
            return JiraKeyUtils.linkBugKeys((String)issue.getEnvironment());
        }
    }

    public Object getCustomFieldValue(String id) {
        CustomField cf = this.customFieldManager.getCustomFieldObject(id);
        if (cf == null) {
            log.warn("Velocity template referenced nonexistent custom field '" + id + "'");
            return null;
        }
        return this.getCustomFieldValue(cf);
    }

    public Long getAggregateOriginalEstimate() {
        return this.getAggregateBean().getOriginalEstimate();
    }

    public Long getAggregateRemainingEstimate() {
        return this.getAggregateBean().getRemainingEstimate();
    }

    public Long getAggregateTimeSpent() {
        return this.getAggregateBean().getTimeSpent();
    }

    private AggregateTimeTrackingBean getAggregateBean() {
        if (this.aggregateBean == null) {
            Issue issue = this.getDelegate();
            this.aggregateBean = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue);
        }
        return this.aggregateBean;
    }

    @Override
    public void store() {
    }

    public String getNiceTimeOriginalEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.getOriginalEstimate(), i18n);
    }

    public String getNiceTimeEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.getEstimate(), i18n);
    }

    public String getNiceTimeSpent(I18nHelper i18n) {
        return this.convertToNiceTime(this.getTimeSpent(), i18n);
    }

    public boolean isAnyAggregateDifferent() {
        return this.isTimeAndAggregateDifferent(this.getOriginalEstimate(), this.getAggregateOriginalEstimate()) || this.isTimeAndAggregateDifferent(this.getEstimate(), this.getAggregateRemainingEstimate()) || this.isTimeAndAggregateDifferent(this.getTimeSpent(), this.getAggregateTimeSpent());
    }

    private boolean isTimeAndAggregateDifferent(Long time, Long aggregate) {
        if (time == null) {
            return aggregate != null;
        }
        return !time.equals(aggregate);
    }

    public String getNiceTimeAggregateOriginalEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.getAggregateOriginalEstimate(), i18n);
    }

    public String getNiceTimeAggregateRemainingEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.getAggregateRemainingEstimate(), i18n);
    }

    public String getNiceTimeAggregateTimeSpent(I18nHelper i18n) {
        return this.convertToNiceTime(this.getAggregateTimeSpent(), i18n);
    }

    private String convertToNiceTime(Long time, I18nHelper i18n) {
        if (time == null) {
            return i18n.getText("viewissue.timetracking.unknown");
        }
        return this.jiraDurationUtils.getFormattedDuration(time, i18n.getLocale());
    }

    public String toString() {
        return "TemplateIssue[issue=" + this.getDelegate() + "]";
    }
}

