/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.builder.EmailBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = LoggerFactory.getLogger(UserMailQueueItem.class);
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private static final Integer PADSIZE = 20;
    private final UserEvent event;
    private final String subjectKey;
    private final String template;
    private final ApplicationProperties applicationProperties;

    public UserMailQueueItem(UserEvent event, String subject, String subjectKey, String template) {
        super(subject);
        this.event = event;
        this.subjectKey = subjectKey;
        this.template = template;
        this.applicationProperties = (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
    }

    public void send() throws MailException {
        this.incrementSendCount();
        try {
            ApplicationUser user = this.event.getUser();
            if (user != null) {
                Map<String, Object> params = this.getUserContextParamsBody(this.event);
                params.put("initiatingUser", this.event.getInitiatingUser());
                params.put("applicationName", this.getApplicationName());
                params.put("product", "jira");
                params.put("padSize", PADSIZE);
                params.put("stringUtils", new StringUtils());
                String templatePath = this.getTemplatePath(this.template);
                I18nBean i18nBean = new I18nBean(user);
                Email email = new Email(user.getEmailAddress());
                MailQueueItem item = new EmailBuilder(email, this.getMimeType(templatePath), i18nBean.getLocale()).withSubject(i18nBean.getText(this.getSubjectKey())).withBodyFromFile(templatePath).addParameters(params).renderLater();
                this.getMailQueue().addItem(item);
            } else {
                log.warn("Mail with subject '" + this.getSubject() + "' not sent since user '" + user + "' no longer exists.");
            }
        }
        catch (Exception ex) {
            throw new MailException((Throwable)ex);
        }
    }

    public String getSubjectKey() {
        return this.subjectKey;
    }

    @VisibleForTesting
    MailQueue getMailQueue() {
        return ComponentAccessor.getMailQueue();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    protected Map<String, Object> getUserContextParamsBody(UserEvent uEvent) {
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.put("user", uEvent.getUser());
        contextParams.put("params", uEvent.getParams());
        return contextParams;
    }

    private String getApplicationName() {
        return this.applicationProperties.getText("jira.title");
    }

    private String getTemplatePath(String template) {
        boolean renderAsHtml = ClassLoaderUtils.getResource((String)("templates/email/html/" + template), ((Object)((Object)this)).getClass()) != null;
        String prefix = renderAsHtml ? "html/" : "text/";
        return EMAIL_TEMPLATES + prefix + template;
    }

    private String getMimeType(String template) {
        boolean renderAsHtml = template.contains("html");
        return renderAsHtml ? "text/html" : "text/plain";
    }
}

