/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.builder;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.mail.BidiCharsInliner;
import com.atlassian.jira.mail.CssInliner;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.mail.util.MailAttachmentsManagerFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSource;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.template.velocity.EmailVelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EmailRenderer {
    private static final Logger log = LoggerFactory.getLogger(EmailRenderer.class);
    private final Email email;
    private final TemplateSource subjectTemplate;
    private final TemplateSource bodyTemplate;
    private final Set<BodyPart> attachments;
    private final Map<String, Object> templateParameters;
    private final CssInliner cssInliner;
    private final VelocityTemplatingEngine templatingEngine;
    private final MailAttachmentsManagerFactory mailAttachmentsManagerFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final BidiCharsInliner bidiCharsInliner;

    public EmailRenderer(Email email, TemplateSource subjectTemplate, TemplateSource bodyTemplate, Set<BodyPart> attachments, Map<String, Object> templateParameters) {
        this.email = email;
        this.subjectTemplate = subjectTemplate;
        this.bodyTemplate = bodyTemplate;
        this.attachments = attachments;
        this.templateParameters = templateParameters;
        this.cssInliner = Objects.requireNonNull((CssInliner)ComponentAccessor.getComponent(CssInliner.class));
        this.templatingEngine = Objects.requireNonNull((EmailVelocityTemplatingEngine)ComponentAccessor.getComponent(EmailVelocityTemplatingEngine.class));
        this.mailAttachmentsManagerFactory = Objects.requireNonNull((MailAttachmentsManagerFactory)ComponentAccessor.getComponent(MailAttachmentsManagerFactory.class));
        this.jiraAuthenticationContext = Objects.requireNonNull(ComponentAccessor.getJiraAuthenticationContext());
        this.bidiCharsInliner = new BidiCharsInliner();
    }

    public Email getEmail() {
        return this.email;
    }

    public String getSubject() {
        I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
        Map<String, Object> contextParams = JiraMailQueueUtils.getContextParamsBody(this.templateParameters);
        contextParams.put("i18n", i18n);
        try {
            return this.renderEmailSubject(contextParams);
        }
        catch (VelocityException e) {
            log.error("Could not determine e-mail subject", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String renderEmailSubject(Map<String, Object> contextParams) {
        return this.templatingEngine.render(this.subjectTemplate).applying(contextParams).asPlainText();
    }

    private MailAttachmentsManager createMailAttachmentsManger(Map<String, Object> contextParams) {
        String recipientUserName = (String)contextParams.get("recipientUserName");
        MailAttachmentsManager attachmentsManager = recipientUserName != null ? this.mailAttachmentsManagerFactory.createAttachmentsManagerWithJwtTokens(recipientUserName) : this.mailAttachmentsManagerFactory.createAttachmentsManager();
        return attachmentsManager;
    }

    private void renderEmailBody(Map<String, Object> contextParams) throws MessagingException {
        MailAttachmentsManager attachmentsManager = this.createMailAttachmentsManger(contextParams);
        contextParams.put("attachmentsManager", attachmentsManager);
        String renderedMailBody = this.email.getMimeType().equals("text/html") ? this.renderHtmlBody(contextParams) : this.renderPlainTextBody(contextParams);
        if (attachmentsManager.getAttachmentsCount() + this.attachments.size() > 0) {
            String contentType = String.format("%s; charset=%s", this.email.getMimeType(), this.email.getEncoding());
            Multipart multiPart = this.buildMailWithAttachments(attachmentsManager, renderedMailBody, contentType);
            this.email.setMultipart(multiPart);
        } else {
            this.email.setBody(renderedMailBody);
        }
    }

    private String renderPlainTextBody(Map<String, Object> contextParams) {
        contextParams.put("atlassian-renderer-mentions-full-usernames", true);
        return this.templatingEngine.render(this.bodyTemplate).applying(contextParams).asPlainText();
    }

    private String renderHtmlBody(Map<String, Object> contextParams) {
        String renderedMailBody = this.renderPlainTextBody(contextParams);
        String withInlinedCss = this.cssInliner.applyStyles(renderedMailBody);
        return this.bidiCharsInliner.inline(withInlinedCss);
    }

    private Multipart buildMailWithAttachments(MailAttachmentsManager attachmentsManager, String text, String textContentMimeType) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("related");
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)text, textContentMimeType);
        multipart.addBodyPart((BodyPart)textPart);
        Iterable bodyParts = Iterables.concat(attachmentsManager.buildAttachmentsBodyParts(), this.attachments);
        for (BodyPart bodyPart : bodyParts) {
            multipart.addBodyPart(bodyPart);
        }
        return multipart;
    }

    public Email render() throws MessagingException {
        this.email.setSubject(this.renderEmailSubject(this.templateParameters));
        this.renderEmailBody(this.templateParameters);
        return this.email;
    }
}

