/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.commons.io.IOUtils;

public class ByteArrayDataSource
implements DataSource {
    private ByteArrayOutputStream baos;
    private final String contentType;

    public ByteArrayDataSource(InputStream inputStream, String contentType) throws IOException {
        this.contentType = contentType == null ? "application/octet-stream" : contentType;
        this.baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)this.baos);
        this.baos.close();
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.baos.toByteArray());
    }

    public String getName() {
        return "ByteArrayDataSource";
    }

    public OutputStream getOutputStream() throws IOException {
        this.baos = new ByteArrayOutputStream();
        return this.baos;
    }
}

