/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.memoryinspector;

import com.atlassian.jira.memoryinspector.InspectionReport;
import com.atlassian.jira.memoryinspector.ThreadInfo;
import com.atlassian.jira.memoryinspector.ThreadInfoPredicate;
import com.atlassian.jira.memoryinspector.ThreadsInspectionReport;
import com.atlassian.jira.memoryinspector.ThreadsInspector;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadsInspectorImpl
implements ThreadsInspector {
    private static final Logger log = LoggerFactory.getLogger(ThreadsInspectorImpl.class);
    public static final Function<Thread, ThreadInfo> THREAD_TO_THREAD_INFO_FUNCTION = new Function<Thread, ThreadInfo>(){

        public ThreadInfo apply(Thread thread) {
            try {
                return new ThreadInfo(thread);
            }
            catch (Exception e) {
                log.warn("Got exception while getting thread info for thread: " + thread, (Throwable)e);
                return null;
            }
        }
    };
    private final List<Predicate<ThreadInfo>> knownBaseThreads = ImmutableList.builder().add(this.and(ThreadInfoPredicate.matchClass("\\Qjava.util.TimerThread\\E"), ThreadInfoPredicate.matchGroup("main"), ThreadInfoPredicate.matchName("Timer-\\d+|commons-pool-EvictionTimer"), ThreadInfoPredicate.matchClassLoaderClassName("(\\Qorg.apache.catalina.loader.WebappClassLoader\\E|\\Qorg.apache.catalina.loader.StandardClassLoader\\E)"))).add(ThreadInfoPredicate.matchNameAndGroup("(http|ajp)(-bio)?-\\d+-Acceptor-\\d+", "main")).add(ThreadInfoPredicate.matchNameAndGroup("(http|ajp)(-bio)?-\\d+-AsyncTimeout", "main")).add(ThreadInfoPredicate.matchNameAndGroup("ContainerBackgroundProcessor\\[StandardEngine\\[Catalina\\]\\]", "main")).add(ThreadInfoPredicate.matchClassAndNameAndGroup("\\Qorg.apache.tomcat.util.threads.TaskThread\\E", "(http|ajp)-bio-\\d+-exec-\\d+", "main")).add((Object)new TomcatNioThreadPoolExecutorMatcher()).add(this.and(ThreadInfoPredicate.matchClassAndNameAndGroup("\\Qjava.lang.Thread\\E", "TP-Monitor", "main"), ThreadInfoPredicate.matchClassLoaderClassName("\\Qorg.apache.catalina.loader.StandardClassLoader\\E"))).add(this.and(ThreadInfoPredicate.matchClassAndNameAndGroup("\\Qorg.apache.tomcat.util.threads.ThreadWithAttributes\\E", "TP-Processor\\d+", "main"), ThreadInfoPredicate.matchClassLoaderClassName("\\Qorg.apache.catalina.loader.StandardClassLoader\\E"))).add(ThreadInfoPredicate.matchClassAndName("\\Qorg.objectweb.jonas_timer.Clock\\E", "JonasClock")).add(ThreadInfoPredicate.matchClassAndName("\\Qorg.objectweb.jonas_timer.Batch\\E", "JonasBatch")).add(ThreadInfoPredicate.matchNameAndGroup("Finalizer", "system")).add(ThreadInfoPredicate.matchNameAndGroup("Signal Dispatcher", "system")).add(ThreadInfoPredicate.matchNameAndGroup("Reference Handler", "system")).add(ThreadInfoPredicate.matchNameAndGroup("GC Daemon", "system")).add(ThreadInfoPredicate.matchNameAndGroup("Java2D Disposer", "system")).add(ThreadInfoPredicate.matchNameAndGroup("HSQLDB Timer .*", "main")).add(ThreadInfoPredicate.matchNameAndGroup("H2 File Lock Watchdog .*", "main")).add(ThreadInfoPredicate.matchNameAndGroup("H2 Log Writer H2DB", "main")).add(ThreadInfoPredicate.matchNameAndGroup("MVStore background writer .*", "main")).add(ThreadInfoPredicate.matchClassAndNameAndGroup("\\Qcom.mysql.jdbc.AbandonedConnectionCleanupThread\\E", "\\QAbandoned connection cleanup thread\\E", "main")).add(ThreadInfoPredicate.matchNameAndGroup("main", "main")).add(ThreadInfoPredicate.matchClassAndName("\\Qjava.lang.Thread\\E", "Felix(StartLevel|DispatchQueue|PackageAdmin|Shutdown)")).add(ThreadInfoPredicate.matchState(Thread.State.TERMINATED)).add(ThreadInfoPredicate.matchGroup("RMI Runtime")).add(ThreadInfoPredicate.matchNameAndGroup("RMI TCP Accept-\\d", "system")).add(ThreadInfoPredicate.matchName("JMX server connection timeout.*")).add(ThreadInfoPredicate.matchNameAndGroup("RMI Scheduler.*", "system")).add(ThreadInfoPredicate.matchNameAndGroup("Attach Listener", "system")).add(ThreadInfoPredicate.matchNameAndGroup("JiraImportTaskExecutionThread-\\d+", "main")).add(ThreadInfoPredicate.matchNameAndGroup("Monitor Ctrl-Break", "main")).add(ThreadInfoPredicate.matchNameAndGroup("NioBlockingSelector.BlockPoller-.*", "main")).add(ThreadInfoPredicate.matchNameAndGroup("ajp-nio-.*", "main")).add(ThreadInfoPredicate.matchNameAndGroup("http-nio-.*", "main")).add(ThreadInfoPredicate.matchNameAndGroup("AWT-AppKit", "system")).add(ThreadInfoPredicate.matchClassAndNameAndGroup("\\Qjava.lang.Thread\\E", "AWT-Windows", "system")).add(ThreadInfoPredicate.matchClassAndNameAndGroup("\\Qorg.apache.juli.AsyncFileHandler.LoggerThread\\E", "AsyncFileHandlerWriter-\\d+", "main")).build();

    @Override
    public InspectionReport inspectThreads(Iterable<Thread> threads) {
        return this.inspectThreadInfos(this.transformThreadsToThreadInfo(threads));
    }

    ThreadsInspectionReport inspectThreadInfos(Iterable<ThreadInfo> threadInfos) {
        return this.inspectThreads(threadInfos, this.knownBaseThreads);
    }

    final Iterable<ThreadInfo> transformThreadsToThreadInfo(Iterable<Thread> threads) {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(threads, THREAD_TO_THREAD_INFO_FUNCTION), (Predicate)Predicates.notNull()));
    }

    ThreadsInspectionReport inspectThreads(Iterable<ThreadInfo> threadInfo, List<Predicate<ThreadInfo>> knownThreads) {
        return new ThreadsInspectionReport((List<ThreadInfo>)ImmutableList.copyOf((Iterable)Iterables.filter(threadInfo, (Predicate)Predicates.not((Predicate)Predicates.or(knownThreads)))));
    }

    private Predicate<ThreadInfo> and(Predicate<ThreadInfo> ... predicates) {
        return Predicates.and(predicates);
    }

    public static class TomcatNioThreadPoolExecutorMatcher
    implements Predicate<ThreadInfo> {
        public boolean apply(ThreadInfo threadInfo) {
            if (ThreadInfoPredicate.matchClassAndNameAndGroup("\\Qjava.lang.Thread\\E", "Thread-\\d+", "main").apply((Object)threadInfo)) {
                try {
                    Thread thread = threadInfo.getThread();
                    Object threadTarget = this.getFieldValueWithClassCheck(thread, "target", "sun.nio.ch.EPollPort.EventHandlerTask");
                    Object outerThis = this.getFieldValueWithClassCheck(threadTarget, "this$0", "sun.nio.ch.EPollPort");
                    Object pool = this.getFieldValueWithClassCheck(outerThis, "pool", "sun.nio.ch.ThreadPool");
                    Object poolExecutor = this.getFieldValueWithClassCheck(pool, "executor", "org.apache.tomcat.util.threads.ThreadPoolExecutor");
                    return poolExecutor != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        @Nullable
        private Object getFieldValueWithClassCheck(@Nullable Object object, String fieldName, String expectedClassName) throws NoSuchFieldException, IllegalAccessException {
            if (object == null) {
                return null;
            }
            Field field = this.findField(object.getClass(), fieldName);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            Object value = field.get(object);
            return value != null && expectedClassName.equals(value.getClass().getCanonicalName()) ? value : null;
        }

        @Nullable
        private Field findField(@Nullable Class clazz, String fieldName) {
            if (clazz == null) {
                return null;
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
            return this.findField(clazz.getSuperclass(), fieldName);
        }
    }
}

