/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention.stats;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.crowd.embedded.JiraCrowdDAO;
import com.atlassian.jira.crowd.embedded.QueryDslJiraCrowdDAO;
import com.atlassian.jira.mention.stats.UserSearchServiceStats;
import com.atlassian.jira.model.querydsl.UserDTO;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class JiraCrowdDAOWithStats
implements JiraCrowdDAO {
    private final JiraCrowdDAO delegate;
    private final UserSearchServiceStats userSearchServiceStats;

    public JiraCrowdDAOWithStats(JiraCrowdDAO delegate, UserSearchServiceStats userSearchServiceStats) {
        this.delegate = delegate;
        this.userSearchServiceStats = userSearchServiceStats;
        this.userSearchServiceStats.queryDslJiraCrowdDAOSettings(QueryDslJiraCrowdDAO.MAX_TOP, QueryDslJiraCrowdDAO.GROUP_BATCH_SIZE, QueryDslJiraCrowdDAO.NUMBER_OF_GROUP_BATCHES, QueryDslJiraCrowdDAO.MAX_GROUP_NESTED_LEVEL);
    }

    @Override
    public List<UserDTO> findTopUsersWithNameInGroups(String searchName, Set<Group> groups, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<UserDTO> delegateResult = this.delegate.findTopUsersWithNameInGroups(searchName, groups, topN);
            this.userSearchServiceStats.findTopUsersWithNameInGroups(groups.size(), delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findTopUsersWithNameInGroupsException(groups.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findTopUsersWithNameInGroups; groups=" + groups + ", searchName=" + searchName + ", topN=" + topN, e);
        }
    }

    @Override
    public List<UserDTO> findTopUsers(String searchName, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<UserDTO> delegateResult = this.delegate.findTopUsers(searchName, topN);
            this.userSearchServiceStats.findTopUsers(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findTopUsersException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findTopUsers; searchName=" + searchName + ", topN=" + topN, e);
        }
    }

    @Override
    public Set<Group> findNestedGroupsOf(Set<Group> groups) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Set<Group> delegateResult = this.delegate.findNestedGroupsOf(groups);
            this.userSearchServiceStats.findNestedGroupsOf(groups.size(), delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findNestedGroupsOfException(groups.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findNestedGroupsOf; groups=" + groups, e);
        }
    }
}

