/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.model.querydsl;

import com.atlassian.jira.model.querydsl.DTO;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.base.MoreObjects;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class ComponentDTO
implements DTO {
    private final Long id;
    private final Long project;
    private final String name;
    private final String description;
    private final String url;
    private final String lead;
    private final Long assigneetype;
    private final String archived;
    private final String deleted;

    public Long getId() {
        return this.id;
    }

    public Long getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLead() {
        return this.lead;
    }

    public Long getAssigneetype() {
        return this.assigneetype;
    }

    public String getArchived() {
        return this.archived;
    }

    public String getDeleted() {
        return this.deleted;
    }

    public ComponentDTO(Long id, Long project, String name, String description, String url, String lead, Long assigneetype, String archived, String deleted) {
        this.id = id;
        this.project = project;
        this.name = name;
        this.description = description;
        this.url = url;
        this.lead = lead;
        this.assigneetype = assigneetype;
        this.archived = archived;
        this.deleted = deleted;
    }

    @Override
    public GenericValue toGenericValue(OfBizDelegator ofBizDelegator) {
        return ofBizDelegator.makeValue("Component", (Map)new FieldMap().add("id", (Object)this.id).add("project", (Object)this.project).add("name", (Object)this.name).add("description", (Object)this.description).add("url", (Object)this.url).add("lead", (Object)this.lead).add("assigneetype", (Object)this.assigneetype).add("archived", (Object)this.archived).add("deleted", (Object)this.deleted));
    }

    public static ComponentDTO fromGenericValue(GenericValue gv) {
        return new ComponentDTO(gv.getLong("id"), gv.getLong("project"), gv.getString("name"), gv.getString("description"), gv.getString("url"), gv.getString("lead"), gv.getLong("assigneetype"), gv.getString("archived"), gv.getString("deleted"));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("project", (Object)this.project).add("name", (Object)this.name).add("description", (Object)this.description).add("url", (Object)this.url).add("lead", (Object)this.lead).add("assigneetype", (Object)this.assigneetype).add("archived", (Object)this.archived).add("deleted", (Object)this.deleted).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ComponentDTO componentDTO) {
        return new Builder(componentDTO);
    }

    public static class Builder {
        private Long id;
        private Long project;
        private String name;
        private String description;
        private String url;
        private String lead;
        private Long assigneetype;
        private String archived;
        private String deleted;

        public Builder() {
        }

        public Builder(ComponentDTO componentDTO) {
            this.id = componentDTO.id;
            this.project = componentDTO.project;
            this.name = componentDTO.name;
            this.description = componentDTO.description;
            this.url = componentDTO.url;
            this.lead = componentDTO.lead;
            this.assigneetype = componentDTO.assigneetype;
            this.archived = componentDTO.archived;
            this.deleted = componentDTO.deleted;
        }

        public ComponentDTO build() {
            return new ComponentDTO(this.id, this.project, this.name, this.description, this.url, this.lead, this.assigneetype, this.archived, this.deleted);
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder project(Long project) {
            this.project = project;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder lead(String lead) {
            this.lead = lead;
            return this;
        }

        public Builder assigneetype(Long assigneetype) {
            this.assigneetype = assigneetype;
            return this;
        }

        public Builder archived(String archived) {
            this.archived = archived;
            return this;
        }

        public Builder deleted(String deleted) {
            this.deleted = deleted;
            return this;
        }
    }
}

