/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.model.querydsl;

import com.atlassian.jira.model.querydsl.DTO;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class MembershipDTO
implements DTO {
    private final Long id;
    private final Long parentId;
    private final Long childId;
    private final String membershipType;
    private final String groupType;
    private final String parentName;
    private final String lowerParentName;
    private final String childName;
    private final String lowerChildName;
    private final Long directoryId;

    public Long getId() {
        return this.id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public Long getChildId() {
        return this.childId;
    }

    public String getMembershipType() {
        return this.membershipType;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getLowerParentName() {
        return this.lowerParentName;
    }

    public String getChildName() {
        return this.childName;
    }

    public String getLowerChildName() {
        return this.lowerChildName;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public MembershipDTO(Long id, Long parentId, Long childId, String membershipType, String groupType, String parentName, String lowerParentName, String childName, String lowerChildName, Long directoryId) {
        this.id = id;
        this.parentId = parentId;
        this.childId = childId;
        this.membershipType = membershipType;
        this.groupType = groupType;
        this.parentName = parentName;
        this.lowerParentName = lowerParentName;
        this.childName = childName;
        this.lowerChildName = lowerChildName;
        this.directoryId = directoryId;
    }

    @Override
    public GenericValue toGenericValue(OfBizDelegator ofBizDelegator) {
        return ofBizDelegator.makeValue("Membership", (Map)new FieldMap().add("id", (Object)this.id).add("parentId", (Object)this.parentId).add("childId", (Object)this.childId).add("membershipType", (Object)this.membershipType).add("groupType", (Object)this.groupType).add("parentName", (Object)this.parentName).add("lowerParentName", (Object)this.lowerParentName).add("childName", (Object)this.childName).add("lowerChildName", (Object)this.lowerChildName).add("directoryId", (Object)this.directoryId));
    }

    public static MembershipDTO fromGenericValue(GenericValue gv) {
        return new MembershipDTO(gv.getLong("id"), gv.getLong("parentId"), gv.getLong("childId"), gv.getString("membershipType"), gv.getString("groupType"), gv.getString("parentName"), gv.getString("lowerParentName"), gv.getString("childName"), gv.getString("lowerChildName"), gv.getLong("directoryId"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MembershipDTO membershipDTO) {
        return new Builder(membershipDTO);
    }

    public static class Builder {
        private Long id;
        private Long parentId;
        private Long childId;
        private String membershipType;
        private String groupType;
        private String parentName;
        private String lowerParentName;
        private String childName;
        private String lowerChildName;
        private Long directoryId;

        public Builder() {
        }

        public Builder(MembershipDTO membershipDTO) {
            this.id = membershipDTO.id;
            this.parentId = membershipDTO.parentId;
            this.childId = membershipDTO.childId;
            this.membershipType = membershipDTO.membershipType;
            this.groupType = membershipDTO.groupType;
            this.parentName = membershipDTO.parentName;
            this.lowerParentName = membershipDTO.lowerParentName;
            this.childName = membershipDTO.childName;
            this.lowerChildName = membershipDTO.lowerChildName;
            this.directoryId = membershipDTO.directoryId;
        }

        public MembershipDTO build() {
            return new MembershipDTO(this.id, this.parentId, this.childId, this.membershipType, this.groupType, this.parentName, this.lowerParentName, this.childName, this.lowerChildName, this.directoryId);
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder parentId(Long parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder childId(Long childId) {
            this.childId = childId;
            return this;
        }

        public Builder membershipType(String membershipType) {
            this.membershipType = membershipType;
            return this;
        }

        public Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        public Builder parentName(String parentName) {
            this.parentName = parentName;
            return this;
        }

        public Builder lowerParentName(String lowerParentName) {
            this.lowerParentName = lowerParentName;
            return this;
        }

        public Builder childName(String childName) {
            this.childName = childName;
            return this;
        }

        public Builder lowerChildName(String lowerChildName) {
            this.lowerChildName = lowerChildName;
            return this;
        }

        public Builder directoryId(Long directoryId) {
            this.directoryId = directoryId;
            return this;
        }
    }
}

