/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;

public class DefaultOfBizConnectionFactory
implements OfBizConnectionFactory {
    private final DatabaseConfigurationManager databaseConfigurationManager;
    private final EntityConfigUtil entityConfigUtil = EntityConfigUtil.getInstance();

    public DefaultOfBizConnectionFactory(@Nonnull DatabaseConfigurationManager databaseConfigurationManager) {
        this.databaseConfigurationManager = Objects.requireNonNull(databaseConfigurationManager);
    }

    @Override
    public Connection getConnection() throws SQLException, DataAccessException {
        try {
            return ConnectionFactory.getConnection((String)this.getDatabaseConfig().getDatasourceName());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public DatasourceInfo getDatasourceInfo() {
        return this.entityConfigUtil.getDatasourceInfo(this.getDatabaseConfig().getDatasourceName());
    }

    @Override
    public String getDelegatorName() {
        return this.getDatabaseConfig().getDelegatorName();
    }

    @Deprecated
    @Nullable
    public static DefaultOfBizConnectionFactory getInstance() {
        return (DefaultOfBizConnectionFactory)ComponentAccessor.getComponent(DefaultOfBizConnectionFactory.class);
    }

    private DatabaseConfig getDatabaseConfig() {
        return this.databaseConfigurationManager.getDatabaseConfiguration();
    }
}

