/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.project.Project;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IssueGenericValue
extends GenericValue {
    private static final Logger log = LoggerFactory.getLogger(IssueGenericValue.class);

    IssueGenericValue(GenericValue genericValue) {
        super(genericValue);
    }

    public Object get(String name) {
        if ("key".equals(name)) {
            Long issueNumber = super.getLong("number");
            if (issueNumber != null) {
                Long projectId = this.getLong("project");
                if (projectId == null) {
                    log.warn(String.format("Issue (id=%d) has empty field 'project'. Returning null for 'key'.", this.getLong("id")));
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Issue (id=%d) has empty field 'project'. Returning null for 'key'.", this.getLong("id")), (Throwable)new RuntimeException());
                    }
                    return null;
                }
                Project project = ComponentAccessor.getProjectManager().getProjectObj(projectId);
                if (project == null) {
                    log.warn(String.format("Issue (id=%d) has field 'project' of value %d, but no project with this id can be found. Returning null for 'key'.", this.getLong("id"), projectId));
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Issue (id=%d) has field 'project' of value %d, but no project with this id can be found. Returning null for 'key'.", this.getLong("id"), projectId), (Throwable)new RuntimeException());
                    }
                    return null;
                }
                return IssueKey.format((Project)project, (long)issueNumber);
            }
            Object key = super.get("key");
            if (key == null) {
                log.warn(String.format("Issue (id=%d) has empty field 'num'. Returning null for 'key'.", this.getLong("id")));
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Issue (id=%d) has empty field 'num'. Returning null for 'key'.", this.getLong("id")), (Throwable)new RuntimeException());
                }
                return null;
            }
            return key;
        }
        return super.get(name);
    }

    public void set(String name, Object value) {
        if ("key".equals(name)) {
            if (value == null) {
                throw new NullPointerException("One can not set 'key' to null for Issue entity because its mapped to 'number' and no sensible value can be derived from null.");
            }
            super.set("number", (Object)IssueKey.from((String)((String)value)).getIssueNumber());
        } else {
            super.set(name, value);
        }
    }
}

