/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.permission.PermissionAddedEvent;
import com.atlassian.jira.event.permission.PermissionDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeAddedToProjectEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCopiedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCreatedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.permission.PermissionSchemeUpdatedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEntityEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeAttributeManager;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeUtil;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.ProjectWidePermission;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.AbstractIssueFieldSecurityType;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.SchemePermissionsFKChangedEvent;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPermissionSchemeManager
extends AbstractSchemeManager
implements PermissionSchemeManager,
Startable,
GroupConfigurable {
    private static final Logger log = LoggerFactory.getLogger(DefaultPermissionSchemeManager.class);
    @VisibleForTesting
    static final String SCHEME_ENTITY_NAME = "PermissionScheme";
    private static final String PERMISSION_ENTITY_NAME = "SchemePermissions";
    private static final String SCHEME_DESC = "Permission";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.permissions.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.permissions.default.desc";
    private final Cache<Long, SchemeEntityCacheEntry> schemeEntityCache;
    private final PermissionTypeManager permissionTypeManager;
    private final OfBizDelegator delegator;
    private final PermissionSchemeAttributeManager permissionSchemeAttributeManager;

    public DefaultPermissionSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, OfBizDelegator delegator, SchemeFactory schemeFactory, NodeAssociationStore nodeAssociationStore, GroupManager groupManager, EventPublisher eventPublisher, CacheManager cacheManager, PermissionSchemeAttributeManager permissionSchemeAttributeManager) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, nodeAssociationStore, delegator, groupManager, eventPublisher, cacheManager);
        this.permissionTypeManager = permissionTypeManager;
        this.delegator = delegator;
        this.permissionSchemeAttributeManager = permissionSchemeAttributeManager;
        this.schemeEntityCache = cacheManager.getCache(DefaultPermissionSchemeManager.class.getName() + ".schemeEntityCache", x$0 -> new SchemeEntityCacheEntry((Long)x$0), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void start() throws Exception {
    }

    @Override
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches(event);
    }

    public void onSchemePermissionsFKChangedEvent(SchemePermissionsFKChangedEvent event) {
        this.flushSchemeEntities();
    }

    private void clearCaches(ClearCacheEvent event) {
        super.onClearCache(event);
        this.flushSchemeEntities();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return PERMISSION_ENTITY_NAME;
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    @Override
    protected AbstractSchemeEvent createSchemeCreatedEvent(Scheme scheme) {
        return new PermissionSchemeCreatedEvent(scheme);
    }

    @Override
    @Nonnull
    protected AbstractSchemeCopiedEvent createSchemeCopiedEvent(@Nonnull Scheme oldScheme, @Nonnull Scheme newScheme) {
        return new PermissionSchemeCopiedEvent(oldScheme, newScheme);
    }

    @Override
    protected AbstractSchemeUpdatedEvent createSchemeUpdatedEvent(Scheme scheme, Scheme originalScheme) {
        return new PermissionSchemeUpdatedEvent(scheme, originalScheme);
    }

    @Override
    public void deleteScheme(Long id) throws GenericEntityException {
        if (id != null && id != 0L) {
            Scheme scheme = this.getSchemeObject(id);
            this.permissionSchemeAttributeManager.clearAttributes(id);
            super.deleteScheme(id);
            Objects.requireNonNull(scheme);
            this.eventPublisher.publish((Object)new PermissionSchemeDeletedEvent(id, scheme.getName()));
        }
    }

    @Override
    @Nonnull
    protected AbstractSchemeAddedToProjectEvent createSchemeAddedToProjectEvent(Scheme scheme, Project project) {
        return new PermissionSchemeAddedToProjectEvent(scheme, project);
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId) throws GenericEntityException {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.getEntities(scheme, permissionKey);
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId, String parameter) throws GenericEntityException {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.getEntities(scheme, permissionKey, parameter);
    }

    public List<GenericValue> getEntities(@Nonnull GenericValue scheme, @Nonnull ProjectPermissionKey permissionKey, @Nonnull String parameter) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme, permissionKey), Collections.singletonMap("parameter", parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId, String type, String parameter) throws GenericEntityException {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.getEntities(scheme, permissionKey, type, parameter);
    }

    public List<GenericValue> getEntities(@Nonnull GenericValue scheme, @Nonnull ProjectPermissionKey permissionKey, @Nonnull String type, @Nonnull String parameter) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme, permissionKey), (Map)MapBuilder.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long permissionId) throws GenericEntityException {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        Long schemeId = scheme.getLong("id");
        Collection<PermissionSchemeEntry> schemeEntries = this.getPermissionSchemeEntries(schemeId, permissionKey, type);
        return CollectionUtil.transform(schemeEntries, Entity.PERMISSION_SCHEME_ENTRY::genericValueFrom);
    }

    public List<GenericValue> getEntities(@Nonnull GenericValue scheme, @Nonnull ProjectPermissionKey permissionKey) throws GenericEntityException {
        return this.getEntities(scheme, permissionKey.permissionKey());
    }

    public List<GenericValue> getEntities(GenericValue scheme, String permissionKey) throws GenericEntityException {
        Long key = this.getSchemeEntityCacheKey(scheme);
        Collection<PermissionSchemeEntry> schemeEntries = ((SchemeEntityCacheEntry)this.schemeEntityCache.get((Object)key)).getPermissionSchemeEntries(permissionKey);
        if (schemeEntries == null) {
            return Collections.emptyList();
        }
        return CollectionUtil.transform(schemeEntries, Entity.PERMISSION_SCHEME_ENTRY::genericValueFrom);
    }

    public Collection<PermissionSchemeEntry> getPermissionSchemeEntries(@Nonnull Scheme scheme, @Nonnull ProjectPermissionKey permissionKey) {
        return this.getPermissionSchemeEntries(scheme.getId(), permissionKey);
    }

    public Collection<PermissionSchemeEntry> getPermissionSchemeEntries(long schemeId, @Nonnull ProjectPermissionKey permissionKey) {
        SchemeEntityCacheEntry schemeEntityCacheEntry = (SchemeEntityCacheEntry)this.schemeEntityCache.get((Object)schemeId);
        if (schemeEntityCacheEntry == null) {
            throw new IllegalArgumentException("Unknown Permission Scheme ID: " + schemeId);
        }
        Collection<PermissionSchemeEntry> permissionSchemeEntries = schemeEntityCacheEntry.getPermissionSchemeEntries(permissionKey.permissionKey());
        if (permissionSchemeEntries == null) {
            return Collections.emptyList();
        }
        return permissionSchemeEntries;
    }

    public Collection<PermissionSchemeEntry> getPermissionSchemeEntries(long schemeId, @Nonnull ProjectPermissionKey permissionKey, @Nonnull String type) {
        return this.getPermissionSchemeEntries(schemeId, permissionKey).stream().filter(permissionSchemeEntry -> type.equals(permissionSchemeEntry.getType())).collect(Collectors.toList());
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        GenericValue result = this.createSchemeEntityNoEvent(scheme, schemeEntity);
        this.eventPublisher.publish((Object)new PermissionAddedEvent(scheme.getLong("id"), this.withFixedEntityTypeId(schemeEntity)));
        return result;
    }

    private SchemeEntity withFixedEntityTypeId(SchemeEntity original) {
        if (original.getEntityTypeId() instanceof ProjectPermissionKey) {
            return original;
        }
        ProjectPermissionKey permissionKey = (ProjectPermissionKey)PermissionSchemeUtil.getPermissionKey(original).getOrNull();
        return new SchemeEntity(original.getId(), original.getType(), original.getParameter(), (Object)permissionKey, original.getTemplateId(), original.getSchemeId());
    }

    @Override
    protected GenericValue createSchemeEntityNoEvent(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme passed must NOT be null");
        }
        if (schemeEntity.getType() == null) {
            throw new IllegalArgumentException("Type in SchemeEntity can NOT be null");
        }
        ProjectPermissionKey permissionKey = (ProjectPermissionKey)PermissionSchemeUtil.getPermissionKey(schemeEntity).getOrNull();
        GenericValue perm = EntityUtils.createValue(PERMISSION_ENTITY_NAME, MapBuilder.newBuilder((Object)"scheme", (Object)scheme.getLong("id")).add((Object)"permissionKey", (Object)permissionKey.permissionKey()).add((Object)"type", (Object)schemeEntity.getType()).add((Object)"parameter", (Object)schemeEntity.getParameter()).toMap());
        this.schemeEntityCache.remove((Object)this.getSchemeEntityCacheKey(scheme));
        return perm;
    }

    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        super.deleteEntity(id);
        this.flushSchemeEntities();
    }

    @Override
    public void deleteEntities(Iterable<Long> ids) {
        super.deleteEntities(ids);
        this.flushSchemeEntities();
    }

    protected AbstractSchemeEntityEvent createSchemeEntityDeletedEvent(GenericValue entity) {
        return new PermissionDeletedEvent(entity.getLong("scheme"), this.makeSchemeEntity(entity));
    }

    @Override
    protected SchemeEntity makeSchemeEntity(GenericValue entity) {
        ProjectPermissionKey permissionKey = new ProjectPermissionKey(entity.getString("permissionKey"));
        SchemeEntity schemeEntity = new SchemeEntity(entity.getString("type"), entity.getString("parameter"), (Object)permissionKey);
        schemeEntity.setSchemeId(entity.getLong("scheme"));
        return schemeEntity;
    }

    @Override
    public List<GenericValue> getEntities(GenericValue scheme) throws GenericEntityException {
        Long key = this.getSchemeEntityCacheKey(scheme);
        return Collections.unmodifiableList(((SchemeEntityCacheEntry)this.schemeEntityCache.get((Object)key)).getCache());
    }

    @Override
    public boolean removeEntities(String type, String parameter) throws RemoveException {
        boolean result = super.removeEntities(type, parameter);
        this.flushSchemeEntities();
        return result;
    }

    @Override
    public boolean removeEntities(GenericValue scheme, Long permissionId) throws RemoveException {
        if (Permissions.isGlobalPermission((int)permissionId.intValue())) {
            throw new IllegalArgumentException("PermissionId passed must not be a global permissions " + permissionId.toString() + " is global");
        }
        boolean result = super.removeEntities(scheme, permissionId);
        this.schemeEntityCache.remove((Object)this.getSchemeEntityCacheKey(scheme));
        return result;
    }

    public boolean hasSchemePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project) {
        return this.hasSchemePermission(permissionKey, this.getSchemeIdFor(project), (schemeType, parameter) -> schemeType.hasPermission(project, parameter));
    }

    public boolean hasSchemePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue) {
        return this.hasSchemePermission(permissionKey, this.getSchemeIdFor(issue.getProjectObject()), (schemeType, parameter) -> schemeType.hasPermission(issue, parameter));
    }

    public boolean hasSchemePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        if (user == null) {
            return this.hasSchemePermission(permissionKey, project);
        }
        return this.hasSchemePermission(permissionKey, this.getSchemeIdFor(project), (schemeType, parameter) -> schemeType.hasPermission(project, parameter, user, issueCreation));
    }

    public ProjectWidePermission hasProjectWidePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nonnull ApplicationUser user, boolean issueCreation) {
        Long schemeId = this.getSchemeIdFor(project);
        if (schemeId == null) {
            return ProjectWidePermission.NO_ISSUES;
        }
        Map securityTypes = this.permissionTypeManager.getTypes();
        Collection<PermissionSchemeEntry> entities = this.getPermissionSchemeEntries(schemeId, permissionKey);
        ProjectWidePermission hasPermission = ProjectWidePermission.NO_ISSUES;
        for (PermissionSchemeEntry schemeEntry : entities) {
            SecurityType securityType = (SecurityType)securityTypes.get(schemeEntry.getType());
            if (securityType == null || !securityType.isValidForPermission(permissionKey)) continue;
            if (securityType instanceof AbstractIssueFieldSecurityType) {
                hasPermission = ProjectWidePermission.ISSUE_SPECIFIC;
                continue;
            }
            if (!securityType.hasPermission(project, schemeEntry.getParameter(), user, issueCreation)) continue;
            return ProjectWidePermission.ALL_ISSUES;
        }
        return hasPermission;
    }

    public boolean hasSchemePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, boolean issueCreation) {
        if (user == null) {
            return this.hasSchemePermission(permissionKey, issue);
        }
        return this.hasSchemePermission(permissionKey, this.getSchemeIdFor(issue.getProjectObject()), (schemeType, parameter) -> schemeType.hasPermission(issue, parameter, user, issueCreation));
    }

    @Override
    @Nullable
    public Scheme getSchemeFor(Project project) {
        Scheme scheme = super.getSchemeFor(project);
        if (scheme == null) {
            log.warn("No permission scheme is associated with project '" + project.getName() + "'");
        }
        return scheme;
    }

    @Override
    @Nullable
    public Long getSchemeIdFor(Project project) {
        Long schemeId = super.getSchemeIdFor(project);
        if (schemeId == null) {
            log.warn("No permission scheme is associated with project '" + project.getName() + "'");
        }
        return schemeId;
    }

    @Override
    public Collection<Group> getGroups(Long entityTypeId, Project project) {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(entityTypeId);
        return this.getGroups(permissionKey, project);
    }

    public Collection<Group> getGroups(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project) {
        return this.getGroups(permissionKey, project.getGenericValue());
    }

    @Override
    public Collection<Group> getGroups(Long entityTypeId, GenericValue project) {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(entityTypeId);
        return this.getGroups(permissionKey, project);
    }

    private Collection<Group> getGroups(ProjectPermissionKey permissionKey, GenericValue project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed can NOT be null");
        }
        if (!"Project".equals(project.getEntityName())) {
            throw new IllegalArgumentException("Project passed must be a project not a " + project.getEntityName());
        }
        return this.getSchemeObjects().stream().flatMap(scheme -> this.getPermissionSchemeEntries(scheme.getId(), permissionKey, "group").stream()).map(entry -> this.groupManager.getGroup(entry.getParameter())).collect(Collectors.toSet());
    }

    public Collection<ApplicationUser> getUsers(@Nonnull ProjectPermissionKey permissionKey, @Nonnull PermissionContext ctx) {
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
        Map permTypes = this.securityTypeManager.getTypes();
        Long schemeId = this.getSchemeIdFor(ctx.getProjectObject());
        Collection<PermissionSchemeEntry> entries = this.getPermissionSchemeEntries(schemeId, permissionKey);
        for (PermissionSchemeEntry entry : entries) {
            SecurityType secType = (SecurityType)permTypes.get(entry.getType());
            if (secType == null) continue;
            try {
                Set<ApplicationUser> usersToAdd = secType.getUsers(ctx, entry.getParameter());
                users.addAll(usersToAdd.stream().filter(ApplicationUser::isActive).collect(Collectors.toList()));
            }
            catch (IllegalArgumentException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return users;
    }

    public boolean hasExtendedProjectAdministration(@Nullable Project project) {
        if (project == null) {
            log.debug("Returning 'false' for `hasExtPermission` because the given project is null");
            return false;
        }
        Long schemeId = this.getSchemeIdFor(project);
        if (schemeId == null) {
            log.debug("Returning 'false' for `hasExtPermission` because the given project has no associated permission scheme");
            return false;
        }
        return Boolean.valueOf(this.permissionSchemeAttributeManager.getAttribute(schemeId, "ADMINISTER_PROJECTS.extended.enabled").orElse("false"));
    }

    @Override
    @Nonnull
    protected AbstractSchemeRemovedFromProjectEvent createSchemeRemovedFromProjectEvent(Scheme scheme, Project project) {
        return new PermissionSchemeRemovedFromProjectEvent(scheme, project);
    }

    private boolean hasSchemePermission(ProjectPermissionKey permissionKey, Long schemeId, PermissionSchemeEntryChecker permissionSchemeEntryChecker) {
        if (schemeId == null) {
            return false;
        }
        Map securityTypes = this.permissionTypeManager.getTypes();
        Collection<PermissionSchemeEntry> entities = this.getPermissionSchemeEntries(schemeId, permissionKey);
        for (PermissionSchemeEntry schemeEntry : entities) {
            SecurityType securityType;
            if (schemeEntry == null || (securityType = (SecurityType)securityTypes.get(schemeEntry.getType())) == null || !securityType.isValidForPermission(permissionKey) || !permissionSchemeEntryChecker.hasPermission(securityType, schemeEntry.getParameter())) continue;
            return true;
        }
        return false;
    }

    private Long getSchemeEntityCacheKey(GenericValue scheme) {
        return scheme.getLong("id");
    }

    public void flushSchemeEntities() {
        this.schemeEntityCache.removeAll();
    }

    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        List entities = this.delegator.findByAnd(PERMISSION_ENTITY_NAME, (Map)FieldMap.build((String)"type", (Object)type, (String)"parameter", (Object)parameter));
        List entityConditions = entities.stream().map(schemeEntity -> schemeEntity.getLong("scheme")).map(id -> new EntityExpr("id", EntityOperator.EQUALS, id)).collect(Collectors.toList());
        List schemes = !entityConditions.isEmpty() ? this.delegator.findByOr(SCHEME_ENTITY_NAME, entityConditions, Collections.emptyList()) : Collections.emptyList();
        return schemes;
    }

    @Override
    public void swapParameterForEntitiesOfType(String type, String parameter, String resultingParameter) {
        super.swapParameterForEntitiesOfType(type, parameter, resultingParameter);
        this.flushSchemeEntities();
    }

    @Override
    public boolean isGroupUsed(@Nonnull Group group) {
        List entities = this.delegator.findByAnd(PERMISSION_ENTITY_NAME, (Map)FieldMap.build((String)"type", (Object)"group", (String)"parameter", (Object)group.getName()));
        return !entities.isEmpty();
    }

    private class SchemeEntityCacheEntry {
        private final List<GenericValue> cache;
        private final Map<String, List<PermissionSchemeEntry>> entriesByPermissionKey;

        SchemeEntityCacheEntry(Long key) {
            List schemeEntities;
            try {
                GenericValue scheme = DefaultPermissionSchemeManager.super.getScheme(key);
                schemeEntities = DefaultPermissionSchemeManager.super.getEntities(scheme);
            }
            catch (GenericEntityException e) {
                throw new RuntimeException(e);
            }
            this.cache = schemeEntities;
            HashMap tempMap = Maps.newHashMap();
            for (GenericValue genericValue : schemeEntities) {
                String permissionKey = genericValue.getString("permissionKey");
                ArrayList<PermissionSchemeEntry> entitiesForPermission = (ArrayList<PermissionSchemeEntry>)tempMap.get(permissionKey);
                if (entitiesForPermission == null) {
                    entitiesForPermission = new ArrayList<PermissionSchemeEntry>();
                    tempMap.put(permissionKey, entitiesForPermission);
                }
                entitiesForPermission.add(Entity.PERMISSION_SCHEME_ENTRY.build(genericValue));
            }
            this.entriesByPermissionKey = new HashMap<String, List<PermissionSchemeEntry>>(tempMap.size());
            for (Map.Entry entry : tempMap.entrySet()) {
                this.entriesByPermissionKey.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
        }

        public List<GenericValue> getCache() {
            return this.cache;
        }

        @Nullable
        public Collection<PermissionSchemeEntry> getPermissionSchemeEntries(String permissionKey) {
            return this.entriesByPermissionKey.get(permissionKey);
        }
    }

    private static interface PermissionSchemeEntryChecker {
        public boolean hasPermission(SchemeType var1, String var2);
    }
}

