/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionGrantValidator;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeInput;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeRepresentationConverter;
import com.atlassian.jira.permission.PermissionSchemeService;
import com.atlassian.jira.permission.data.PermissionGrantAsPureData;
import com.atlassian.jira.permission.data.PermissionGrantImpl;
import com.atlassian.jira.permission.data.PermissionSchemeImpl;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@ParametersAreNonnullByDefault
public final class DefaultPermissionSchemeService
implements PermissionSchemeService {
    private final PermissionSchemeManager permissionSchemeManager;
    private final GlobalPermissionManager globalPermissions;
    private final PermissionGrantValidator permissionGrantValidator;
    private final PermissionSchemeRepresentationConverter representationConverter;
    private final ProjectService projectService;
    private final I18nHelper i18n;
    private final UserKeyService userKeyService;
    private final UserManager userManager;

    public DefaultPermissionSchemeService(PermissionSchemeManager permissionSchemeManager, GlobalPermissionManager globalPermissions, PermissionGrantValidator permissionGrantValidator, PermissionSchemeRepresentationConverter representationConverter, ProjectService projectService, I18nHelper i18n, UserKeyService userKeyService, UserManager userManager) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.globalPermissions = globalPermissions;
        this.permissionGrantValidator = permissionGrantValidator;
        this.representationConverter = representationConverter;
        this.projectService = projectService;
        this.i18n = i18n;
        this.userKeyService = userKeyService;
        this.userManager = userManager;
    }

    public ServiceOutcome<ImmutableList<PermissionScheme>> getPermissionSchemes(ApplicationUser user) {
        return DefaultPermissionSchemeService.ok(ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)this.permissionSchemeManager.getSchemeObjects(), scheme -> this.administerProjectsWithScheme(user, (Scheme)scheme)), this.representationConverter::permissionScheme)));
    }

    public ServiceOutcome<PermissionScheme> getPermissionScheme(@Nullable ApplicationUser user, Long id) {
        Either schemeOrError = this.getScheme(user, id);
        return (ServiceOutcome)schemeOrError.left().on(DefaultPermissionSchemeService::ok);
    }

    public ServiceOutcome<PermissionScheme> createPermissionScheme(@Nullable ApplicationUser user, PermissionSchemeInput permissionScheme) {
        return this.asAdmin(user, () -> (ServiceOutcome)this.validateSchemeName(permissionScheme.getName()).left().on(input -> {
            ErrorCollection entitiesValidation = this.permissionGrantValidator.validateGrants(user, permissionScheme.getPermissions());
            if (entitiesValidation.hasAnyErrors()) {
                return ServiceOutcomeImpl.from(entitiesValidation);
            }
            PermissionSchemeInput permissionSchemePersistingUserkey = PermissionSchemeInput.builder((PermissionSchemeInput)permissionScheme).setPermissions(this.updatePermissionsToStoreUserKey(permissionScheme.getPermissions())).build();
            Scheme createdScheme = this.permissionSchemeManager.createSchemeAndEntities(this.representationConverter.scheme(permissionSchemePersistingUserkey));
            return DefaultPermissionSchemeService.ok(this.representationConverter.permissionScheme(createdScheme));
        }));
    }

    public ServiceOutcome<PermissionScheme> updatePermissionScheme(@Nullable ApplicationUser user, Long id, PermissionSchemeInput permissionScheme) {
        return this.asAdmin(user, () -> {
            Either scheme = this.getScheme(user, id);
            if (scheme.isRight()) {
                PermissionScheme originalScheme = (PermissionScheme)scheme.right().get();
                return (ServiceOutcome)this.validateSchemeName(originalScheme.getName(), permissionScheme.getName()).left().on(input -> {
                    PermissionGrantsUpdateRequest updateRequest = this.resolvePermissionGrantsUpdate(originalScheme, permissionScheme);
                    return this.validated(this.permissionGrantValidator.validateGrants(user, updateRequest.grantsToCreate), () -> {
                        PermissionSchemeImpl updatedScheme = new PermissionSchemeImpl(originalScheme.getId(), permissionScheme.getName(), (String)permissionScheme.getDescription().getOrNull());
                        PermissionGrantsUpdateRequest updateRequestPersistingUserkey = new PermissionGrantsUpdateRequest(updateRequest.schemeId, updateRequest.grantsToRemove, this.updatePermissionsToStoreUserKey(updateRequest.grantsToCreate));
                        this.permissionSchemeManager.updateScheme(this.representationConverter.scheme(updatedScheme));
                        this.updatePermissionGrants(updateRequestPersistingUserkey);
                        return this.getPermissionScheme(user, originalScheme.getId());
                    });
                });
            }
            return (ServiceOutcome)scheme.left().get();
        });
    }

    private PermissionGrantsUpdateRequest resolvePermissionGrantsUpdate(PermissionScheme originalScheme, PermissionSchemeInput newScheme) {
        ImmutableMap originalIndex = Maps.uniqueIndex((Iterable)originalScheme.getPermissions(), PermissionGrantAsPureData.TO_PURE_DATA);
        ImmutableSet originalGrants = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)originalScheme.getPermissions(), PermissionGrantAsPureData.TO_PURE_DATA));
        ImmutableSet newGrants = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)newScheme.getPermissions(), PermissionGrantAsPureData.TO_PURE_DATA_2));
        Iterable grantsToRemove = Iterables.transform((Iterable)Sets.difference((Set)originalGrants, (Set)newGrants), ((Map)originalIndex)::get);
        Iterable grantsToCreate = Iterables.transform((Iterable)Sets.difference((Set)newGrants, (Set)originalGrants), PermissionGrantAsPureData.TO_GRANT_INPUT);
        return new PermissionGrantsUpdateRequest(originalScheme.getId(), grantsToRemove, grantsToCreate);
    }

    private void updatePermissionGrants(PermissionGrantsUpdateRequest updateRequest) {
        this.permissionSchemeManager.deleteEntities(Iterables.transform(updateRequest.grantsToRemove, PermissionGrant::getId));
        for (PermissionGrantInput entity : updateRequest.grantsToCreate) {
            this.createPermissionGrant(entity, updateRequest.schemeId);
        }
    }

    private void createPermissionGrant(PermissionGrantInput grant, Long schemeId) {
        try {
            GenericValue schemeAsGenericValue = this.permissionSchemeManager.getScheme(schemeId);
            this.permissionSchemeManager.createSchemeEntity(schemeAsGenericValue, this.representationConverter.schemeEntity(grant, schemeId));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public ServiceResult deletePermissionScheme(@Nullable ApplicationUser user, Long id) {
        return this.asAdmin(user, () -> {
            if (id.equals(this.permissionSchemeManager.getDefaultSchemeObject().getId())) {
                return DefaultPermissionSchemeService.fail(this.i18n.getText("admin.schemes.permissions.cannot.delete.default.scheme"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            Either schemeToDelete = this.getScheme(user, id);
            if (schemeToDelete.isRight()) {
                if (!this.permissionSchemeManager.getProjects(this.representationConverter.scheme((PermissionScheme)schemeToDelete.right().get())).isEmpty()) {
                    return DefaultPermissionSchemeService.fail(this.i18n.getText("admin.schemes.permissions.cannot.delete.with.projects", (Object)id), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                this.permissionSchemeManager.deleteScheme(id);
                return DefaultPermissionSchemeService.ok();
            }
            return (ServiceResult)schemeToDelete.left().get();
        });
    }

    public ServiceResult assignPermissionSchemeToProject(@Nullable ApplicationUser user, Long schemeId, Long projectId) {
        return this.asAdmin(user, () -> (ServiceResult)DefaultPermissionSchemeService.validate(this.projectService.getProjectByIdForAction(user, projectId, ProjectAction.VIEW_PROJECT)).left().on(project -> (ServiceResult)this.getScheme(user, schemeId).left().on(scheme -> {
            this.permissionSchemeManager.removeSchemesFromProject(project);
            this.permissionSchemeManager.addSchemeToProject(project, this.representationConverter.scheme((PermissionScheme)scheme));
            return ServiceOutcomeImpl.ok(null);
        })));
    }

    public ServiceOutcome<PermissionScheme> getSchemeAssignedToProject(@Nullable ApplicationUser user, Long projectId) {
        return (ServiceOutcome)this.projectService.getProjectByIdForAction(user, projectId, ProjectAction.VIEW_PROJECT_CONFIG).fold(project -> {
            Scheme scheme = (Scheme)Option.option((Object)this.permissionSchemeManager.getSchemeFor(project)).getOrElse(() -> ((PermissionSchemeManager)this.permissionSchemeManager).getDefaultSchemeObject());
            return DefaultPermissionSchemeService.ok(this.representationConverter.permissionScheme(scheme));
        }, ServiceOutcomeImpl::new);
    }

    private <T> ServiceOutcome<T> asAdmin(@Nullable ApplicationUser user, final ServiceActionWithResult<T> action) {
        return (ServiceOutcome)this.validateAdmin(user).getOrElse(new Supplier<ServiceOutcome<T>>(){

            @Override
            public ServiceOutcome<T> get() {
                try {
                    return action.perform();
                }
                catch (GenericEntityException e) {
                    return DefaultPermissionSchemeService.this.dbFail(e);
                }
            }
        });
    }

    private ServiceResult asAdmin(@Nullable ApplicationUser user, ServiceAction action) {
        Option forbidden = this.validateAdmin(user);
        if (forbidden.isEmpty()) {
            try {
                return action.perform();
            }
            catch (GenericEntityException e) {
                return this.dbFail(e);
            }
        }
        return (ServiceResult)forbidden.get();
    }

    private <T> Option<ServiceOutcome<T>> validateAdmin(@Nullable ApplicationUser user) {
        String forbiddenMessage = this.i18n.getText("admin.schemes.permissions.forbidden");
        if (user == null) {
            return Option.some(DefaultPermissionSchemeService.fail(forbiddenMessage, ErrorCollection.Reason.NOT_LOGGED_IN));
        }
        if (!this.isAdmin(user)) {
            return Option.some(DefaultPermissionSchemeService.fail(forbiddenMessage, ErrorCollection.Reason.FORBIDDEN));
        }
        return Option.none();
    }

    private boolean isAdmin(ApplicationUser user) {
        return this.globalPermissions.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private <T> Either<ServiceOutcome<T>, PermissionScheme> getScheme(@Nullable ApplicationUser user, Long schemeId) {
        ServiceOutcome doesNotExist = DefaultPermissionSchemeService.fail(this.i18n.getText("admin.schemes.permissions.validation.scheme.does.not.exist", schemeId.toString()), ErrorCollection.Reason.NOT_FOUND);
        try {
            Scheme schemeObject = this.permissionSchemeManager.getSchemeObject(schemeId);
            return Option.option((Object)schemeObject).flatMap(scheme -> {
                if (this.isAdmin(user) || this.administerProjectsWithScheme(user, (Scheme)scheme)) {
                    return Option.some((Object)this.updateSchemeToReturnUsername(this.representationConverter.permissionScheme((Scheme)scheme)));
                }
                return Option.none();
            }).toRight(() -> doesNotExist);
        }
        catch (DataAccessException ex) {
            return Either.left(doesNotExist);
        }
    }

    private boolean administerProjectsWithScheme(ApplicationUser user, Scheme scheme) {
        return this.isAdmin(user) || !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)this.permissionSchemeManager.getProjects(scheme), project -> this.projectService.getProjectByIdForAction(user, project.getId(), ProjectAction.EDIT_PROJECT_CONFIG).isValid()));
    }

    private static <T> ServiceOutcome<T> ok(T value) {
        return ServiceOutcomeImpl.ok(value);
    }

    private static ServiceOutcome<Void> ok() {
        return ServiceOutcomeImpl.ok(null);
    }

    private static <T> ServiceOutcome<T> fail(String message, ErrorCollection.Reason reason) {
        return ServiceOutcomeImpl.error(message, reason);
    }

    private <T> ServiceOutcome<T> dbFail(GenericEntityException e) {
        return DefaultPermissionSchemeService.fail(this.i18n.getText("admin.schemes.permissions.error.database.exception", e.getMessage()), ErrorCollection.Reason.SERVER_ERROR);
    }

    private Either<ServiceOutcome<PermissionScheme>, String> validateSchemeName(String newName) throws GenericEntityException {
        return this.validateSchemeName(null, newName);
    }

    private Either<ServiceOutcome<PermissionScheme>, String> validateSchemeName(@Nullable String oldName, String newName) throws GenericEntityException {
        if (!newName.equals(oldName) && this.permissionSchemeManager.schemeExists(newName)) {
            return Either.left(DefaultPermissionSchemeService.fail(this.i18n.getText("admin.schemes.permissions.scheme.already.exists", newName), ErrorCollection.Reason.VALIDATION_FAILED));
        }
        return Either.right((Object)newName);
    }

    private <T> ServiceOutcome<T> validated(ErrorCollection validationResult, ServiceActionWithResult<T> actionIfValid) {
        try {
            return validationResult.hasAnyErrors() ? ServiceOutcomeImpl.from(validationResult) : actionIfValid.perform();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private Iterable<PermissionGrantInput> updatePermissionsToStoreUserKey(Iterable<PermissionGrantInput> permissions) {
        ArrayList<PermissionGrantInput> permissionsToAdd = new ArrayList<PermissionGrantInput>(Iterables.size(permissions));
        for (PermissionGrantInput perm : permissions) {
            PermissionHolderType type = perm.getHolder().getType();
            if (JiraPermissionHolderType.USER.equals((Object)type)) {
                PermissionHolder newHolder = PermissionHolder.holder((PermissionHolderType)type, (String)this.userKeyService.getKeyForUsername((String)perm.getHolder().getParameter().get()));
                PermissionGrantInput alteredPerm = PermissionGrantInput.newGrant((PermissionHolder)newHolder, (ProjectPermissionKey)perm.getPermission());
                permissionsToAdd.add(alteredPerm);
                continue;
            }
            permissionsToAdd.add(perm);
        }
        return ImmutableList.copyOf(permissionsToAdd);
    }

    private PermissionScheme updateSchemeToReturnUsername(PermissionScheme originalScheme) {
        Collection originalPerms = originalScheme.getPermissions();
        ArrayList<PermissionGrant> updatedPerms = new ArrayList<PermissionGrant>(originalPerms.size());
        for (PermissionGrant perm : originalPerms) {
            PermissionHolderType type = perm.getHolder().getType();
            if (JiraPermissionHolderType.USER.equals((Object)type)) {
                ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown((String)perm.getHolder().getParameter().getOrNull());
                if (user == null) continue;
                String newParameter = user.getUsername();
                PermissionHolder newHolder = PermissionHolder.holder((PermissionHolderType)type, (String)newParameter);
                PermissionGrantImpl alteredPerm = new PermissionGrantImpl(perm.getId(), newHolder, perm.getPermission());
                updatedPerms.add(alteredPerm);
                continue;
            }
            updatedPerms.add(perm);
        }
        return new PermissionSchemeImpl(originalScheme.getId(), originalScheme.getName(), originalScheme.getDescription(), updatedPerms);
    }

    private static <F> Either<ServiceResult, F> validate(ServiceOutcome<F> outcome) {
        if (outcome.isValid()) {
            return Either.right((Object)outcome.get());
        }
        return Either.left((Object)new ServiceResultImpl(outcome.getErrorCollection()));
    }

    private static interface ServiceActionWithResult<T> {
        public ServiceOutcome<T> perform() throws GenericEntityException;
    }

    private static final class PermissionGrantsUpdateRequest {
        private final Long schemeId;
        private final Iterable<PermissionGrant> grantsToRemove;
        private final Iterable<PermissionGrantInput> grantsToCreate;

        public PermissionGrantsUpdateRequest(Long schemeId, Iterable<PermissionGrant> grantsToRemove, Iterable<PermissionGrantInput> grantsToCreate) {
            this.schemeId = schemeId;
            this.grantsToRemove = grantsToRemove;
            this.grantsToCreate = grantsToCreate;
        }
    }

    private static interface ServiceAction {
        public ServiceResult perform() throws GenericEntityException;
    }
}

