/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.model.querydsl.SchemePermissionsDTO;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionSchemeLogic;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PermissionSchemeLogicImpl
implements PermissionSchemeLogic {
    private static final Set<String> JIRA_PERMISSION_TYPES_LOADED_THROUGH_SECURITY_TYPES = ImmutableSet.of((Object)JiraPermissionHolderType.ASSIGNEE_WITH_ASSIGNABLE_PERMISSION.getKey(), (Object)JiraPermissionHolderType.REPORTER_WITH_CREATE_PERMISSION.getKey());
    private static final Set<String> SUPPORTED_TYPES = (Set)Arrays.stream(JiraPermissionHolderType.values()).map(JiraPermissionHolderType::getKey).filter(key -> !JIRA_PERMISSION_TYPES_LOADED_THROUGH_SECURITY_TYPES.contains(key)).collect(CollectorsUtil.toImmutableSet());
    private final ProjectPermissionKey permissionKey;
    private final long permissionSchemeId;
    private final List<SchemePermissionsDTO> schemePermissionsDTOs;
    private final boolean forceReporterPermission;
    private final boolean forceAssigneePermission;

    static PermissionSchemeLogic create(ProjectPermissionKey permissionKey, long permissionSchemeId, List<SchemePermissionsDTO> schemePermissionsDTOs) {
        return new PermissionSchemeLogicImpl(permissionKey, permissionSchemeId, schemePermissionsDTOs, false, false);
    }

    static PermissionSchemeLogic createWithReporterAndAssigneeOverride(ProjectPermissionKey permissionKey, long permissionSchemeId, List<SchemePermissionsDTO> schemePermissionsDTOs) {
        return new PermissionSchemeLogicImpl(permissionKey, permissionSchemeId, schemePermissionsDTOs, true, true);
    }

    private PermissionSchemeLogicImpl(ProjectPermissionKey permissionKey, long permissionSchemeId, List<SchemePermissionsDTO> schemePermissionsDTOs, boolean forceReporterPermission, boolean forceAssigneePermission) {
        this.schemePermissionsDTOs = schemePermissionsDTOs;
        this.permissionKey = permissionKey;
        this.permissionSchemeId = permissionSchemeId;
        this.forceReporterPermission = forceReporterPermission;
        this.forceAssigneePermission = forceAssigneePermission;
    }

    @Override
    public long getPermissionSchemeId() {
        return this.permissionSchemeId;
    }

    @Override
    public ProjectPermissionKey getPermissionKey() {
        return this.permissionKey;
    }

    @Override
    public Set<PermissionSchemeLogic.PermissionTypeWithParameter> unsupportedPermissionTypes() {
        return this.schemePermissionsDTOs.stream().filter(dto -> !SUPPORTED_TYPES.contains(dto.getType())).map(dto -> new PermissionSchemeLogic.PermissionTypeWithParameter(dto.getType(), dto.getParameter())).collect(Collectors.toSet());
    }

    @Override
    public boolean nobodyAllowed() {
        return this.schemePermissionsDTOs.isEmpty();
    }

    @Override
    public boolean allAllowed() {
        return this.isGroupAny() || this.isApplicationRoleAnyLoggedInUser();
    }

    @Override
    public boolean anyUserType() {
        return this.isUserTypeUser() || this.isUserTypeProjectRole() || this.isUserTypeCustomField();
    }

    @Override
    public boolean isUserTypeUser() {
        return this.hasTypeAndParameterNotNullAndNotEmpty(JiraPermissionHolderType.USER.getKey());
    }

    @Override
    public boolean isIssueUserTypeReporter() {
        return this.forceReporterPermission || this.isIssueUserTypeReporterFromScheme();
    }

    boolean isIssueUserTypeReporterFromScheme() {
        return this.hasTypeAndParameterNullOrEmpty(JiraPermissionHolderType.REPORTER.getKey());
    }

    @Override
    public boolean isIssueUserTypeAssignee() {
        return this.forceAssigneePermission || this.isIssueUserTypeAssigneeFromScheme();
    }

    boolean isIssueUserTypeAssigneeFromScheme() {
        return this.hasTypeAndParameterNullOrEmpty(JiraPermissionHolderType.ASSIGNEE.getKey());
    }

    @Override
    public boolean isIssueUserTypeProjectLead() {
        return this.hasTypeAndParameterNullOrEmpty(JiraPermissionHolderType.PROJECT_LEAD.getKey());
    }

    @Override
    public boolean isUserTypeProjectRole() {
        return this.hasTypeAndParameterNotNullAndNotEmpty(JiraPermissionHolderType.PROJECT_ROLE.getKey());
    }

    @Override
    public boolean isUserTypeCustomField() {
        return this.hasTypeAndParameterNotNullAndNotEmpty(JiraPermissionHolderType.USER_CUSTOM_FIELD.getKey());
    }

    @Override
    public boolean anyGroupType() {
        return this.isGroupTypeGroup() || this.isGroupTypeProjectRole() || this.isGroupTypeCustomField() || this.isGroupTypeApplicationRole();
    }

    @Override
    public boolean isGroupTypeGroup() {
        return this.hasTypeAndParameterNotNullAndNotEmpty(JiraPermissionHolderType.GROUP.getKey());
    }

    @Override
    public boolean isGroupTypeProjectRole() {
        return this.hasTypeAndParameterNotNullAndNotEmpty(JiraPermissionHolderType.PROJECT_ROLE.getKey());
    }

    @Override
    public boolean isGroupTypeCustomField() {
        return this.hasTypeAndParameterNotNullAndNotEmpty(JiraPermissionHolderType.GROUP_CUSTOM_FIELD.getKey());
    }

    @Override
    public boolean isGroupAny() {
        return this.hasTypeAndParameterNullOrEmpty(JiraPermissionHolderType.GROUP.getKey());
    }

    @Override
    public boolean isApplicationRoleAnyLoggedInUser() {
        return this.hasTypeAndParameterNullOrEmpty(JiraPermissionHolderType.APPLICATION_ROLE.getKey());
    }

    @Override
    public boolean isGroupTypeApplicationRole() {
        return this.hasTypeAndParameterNotNullAndNotEmpty(JiraPermissionHolderType.APPLICATION_ROLE.getKey());
    }

    private boolean hasTypeAndParameterNullOrEmpty(String type) {
        return this.schemePermissionsDTOs.stream().anyMatch(scheme -> Objects.equals(scheme.getType(), type) && (scheme.getParameter() == null || scheme.getParameter().isEmpty()));
    }

    private boolean hasTypeAndParameterNotNullAndNotEmpty(String type) {
        return this.schemePermissionsDTOs.stream().anyMatch(scheme -> Objects.equals(scheme.getType(), type) && scheme.getParameter() != null && !scheme.getParameter().isEmpty());
    }

    public String toString() {
        return this.schemePermissionsDTOs.stream().map(schemePermissionsDTO -> schemePermissionsDTO.getType() + " = " + schemePermissionsDTO.getParameter()).collect(Collectors.joining(", "));
    }
}

