/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import io.atlassian.fugue.Option;

public final class PermissionSchemeUtil {
    private PermissionSchemeUtil() {
    }

    public static Option<ProjectPermissionKey> getPermissionKey(SchemeEntity schemeEntity) {
        Object entityTypeId = schemeEntity.getEntityTypeId();
        if (entityTypeId instanceof ProjectPermissionKey) {
            return Option.some((Object)((ProjectPermissionKey)entityTypeId));
        }
        if (entityTypeId instanceof String) {
            return Option.some((Object)new ProjectPermissionKey((String)entityTypeId));
        }
        if (entityTypeId instanceof Long) {
            return Option.option((Object)LegacyProjectPermissionKeyMapping.getKey((Long)entityTypeId));
        }
        if (entityTypeId instanceof Integer) {
            return Option.option((Object)LegacyProjectPermissionKeyMapping.getKey((Integer)entityTypeId));
        }
        throw new IllegalArgumentException("Permission scheme IDs must be ProjectPermissionKey, String, long or int values, not: " + entityTypeId.getClass());
    }
}

