/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.management;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionGrantValidator;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.management.ManagedPermissionSchemeEditingService;
import com.atlassian.jira.permission.management.beans.GrantToPermissionInputBean;
import com.atlassian.jira.permission.management.beans.PermissionsInputBean;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ManagedPermissionSchemeEditingServiceImpl
implements ManagedPermissionSchemeEditingService {
    private final PermissionSchemeManager permissionSchemeManager;
    private final I18nHelper i18nHelper;
    private final PermissionGrantValidator permissionGrantValidator;
    private final PermissionTypeManager permissionTypeManager;
    private final PermissionManager permissionManager;
    private final UserKeyService userKeyService;

    public ManagedPermissionSchemeEditingServiceImpl(PermissionSchemeManager permissionSchemeManager, I18nHelper i18nHelper, PermissionGrantValidator permissionGrantValidator, PermissionTypeManager permissionTypeManager, PermissionManager permissionManager, UserKeyService userKeyService) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.i18nHelper = i18nHelper;
        this.permissionGrantValidator = permissionGrantValidator;
        this.permissionTypeManager = permissionTypeManager;
        this.permissionManager = permissionManager;
        this.userKeyService = userKeyService;
    }

    @Override
    public ErrorCollection validateAddPermissions(ApplicationUser applicationUser, PermissionsInputBean inputBean) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (inputBean.getPermissionKeys() == null || inputBean.getPermissionKeys().isEmpty()) {
            errorCollection.addErrorMessage(this.i18nHelper.getText(ErrorMessages.MUST_SELECT_PERMISSION_ERROR.getKey()));
            return errorCollection;
        }
        if (inputBean.getGrants() == null || inputBean.getGrants().isEmpty()) {
            errorCollection.addErrorMessage(this.i18nHelper.getText(ErrorMessages.MUST_SELECT_GRANT_TYPE_ERROR.getKey()));
            return errorCollection;
        }
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(applicationUser, (ErrorCollection)errorCollection);
        for (String permissionKey : inputBean.getPermissionKeys()) {
            for (GrantToPermissionInputBean grant : inputBean.getGrants()) {
                this.validatePermissionAndGrantCombination(errorCollection, applicationUser, new ProjectPermissionKey(permissionKey), grant, (JiraServiceContext)jiraServiceContext);
            }
        }
        return errorCollection;
    }

    private void validatePermissionAndGrantCombination(SimpleErrorCollection errorCollection, ApplicationUser applicationUser, ProjectPermissionKey projectPermissionKey, final GrantToPermissionInputBean grant, JiraServiceContext jiraServiceContext) {
        Option permissionHolderType = JiraPermissionHolderType.fromKey((String)grant.getSecurityType(), (String)((String)grant.getValue().getOrNull()));
        if (permissionHolderType.isDefined()) {
            PermissionHolder permissionHolder = PermissionHolder.holder((PermissionHolderType)((PermissionHolderType)permissionHolderType.get()), (String)((String)grant.getValue().getOrNull()));
            PermissionGrantInput permissionGrantInput = PermissionGrantInput.newGrant((PermissionHolder)permissionHolder, (ProjectPermissionKey)projectPermissionKey);
            errorCollection.addErrorCollection(this.permissionGrantValidator.validateGrant(applicationUser, permissionGrantInput));
            return;
        }
        Option securityTypeOption = Option.option((Object)((SecurityType)this.permissionTypeManager.getSchemeType(grant.getSecurityType())));
        if (securityTypeOption.isEmpty()) {
            errorCollection.addErrorMessage(this.i18nHelper.getText(ErrorMessages.NONEXISTENT_PERMISSION.getKey(), grant.getSecurityType()));
        } else {
            SecurityType securityType = (SecurityType)securityTypeOption.get();
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    this.put(grant.getSecurityType(), (String)grant.getValue().getOrNull());
                }
            };
            securityType.doValidation(grant.getSecurityType(), (Map<String, String>)parameters, jiraServiceContext);
            if (!securityType.isValidForPermission(projectPermissionKey)) {
                ProjectPermission projectPermission = (ProjectPermission)this.permissionManager.getProjectPermission(projectPermissionKey).get();
                String permName = this.i18nHelper.getText(projectPermission.getNameI18nKey());
                errorCollection.addErrorMessage(this.i18nHelper.getText(ErrorMessages.INVALID_PERMISSION_PLUS_GRANT_COMBINATION_ERROR.getKey(), permName, securityType.getDisplayName()));
            }
        }
    }

    @Override
    public boolean addNewSecurityTypes(Scheme schemeObject, PermissionsInputBean inputBean) {
        boolean successfulAdd = true;
        for (String permissionKey : inputBean.getPermissionKeys()) {
            for (GrantToPermissionInputBean grant : inputBean.getGrants()) {
                ProjectPermissionKey projectPermissionKey = new ProjectPermissionKey(permissionKey);
                String securityType = grant.getSecurityType();
                String value = (String)grant.getValue().getOrNull();
                try {
                    if (this.permissionExists(schemeObject, projectPermissionKey, securityType, value)) continue;
                    successfulAdd = this.addSecurityTypeToPermission(schemeObject.getId(), permissionKey, grant) && successfulAdd;
                }
                catch (GenericEntityException e) {
                    throw new DataAccessException((Throwable)e);
                }
            }
        }
        return successfulAdd;
    }

    private boolean addSecurityTypeToPermission(Long permissionSchemeId, String permissionKey, GrantToPermissionInputBean grant) throws GenericEntityException {
        SchemeEntity entity;
        GenericValue schemeAsGenericValue = this.permissionSchemeManager.getScheme(permissionSchemeId);
        if (JiraPermissionHolderType.USER.getKey().equals(grant.getSecurityType())) {
            String userKey = this.userKeyService.getKeyForUsername((String)grant.getValue().getOrNull());
            entity = this.schemeEntity(grant.getSecurityType(), userKey, permissionSchemeId, permissionKey);
        } else {
            entity = this.schemeEntity(grant, permissionSchemeId, permissionKey);
        }
        GenericValue schemeEntity = this.permissionSchemeManager.createSchemeEntity(schemeAsGenericValue, entity);
        return schemeEntity != null;
    }

    private boolean permissionExists(Scheme schemeObject, ProjectPermissionKey permissionKey, String type, String parameter) throws GenericEntityException {
        for (PermissionSchemeEntry permissionSchemeEntry : this.permissionSchemeManager.getPermissionSchemeEntries(schemeObject, permissionKey)) {
            if (!permissionSchemeEntry.getType().equals(type) || !Objects.equal((Object)parameter, (Object)permissionSchemeEntry.getParameter())) continue;
            return true;
        }
        return false;
    }

    private SchemeEntity schemeEntity(GrantToPermissionInputBean permissionGrant, Long permissionSchemeId, String permissionKey) {
        return this.schemeEntity(permissionGrant.getSecurityType(), (String)permissionGrant.getValue().getOrNull(), permissionSchemeId, permissionKey);
    }

    private SchemeEntity schemeEntity(String type, String parameter, Long permissionSchemeId, String permissionKey) {
        return new SchemeEntity(null, type, parameter, (Object)permissionKey, null, permissionSchemeId);
    }

    @VisibleForTesting
    protected static enum ErrorMessages {
        MUST_SELECT_PERMISSION_ERROR("admin.permissions.errors.mustselectpermission"),
        MUST_SELECT_GRANT_TYPE_ERROR("admin.permissions.errors.mustselecttype"),
        INVALID_PERMISSION_PLUS_GRANT_COMBINATION_ERROR("admin.permissions.errors.invalid.combination"),
        NONEXISTENT_PERMISSION("admin.errors.permissions.inexistent.permission");

        private final String key;

        private ErrorMessages(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

