/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.plugin.JiraPluginCacheResetEvent;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginTransactionEndEvent;
import com.atlassian.plugin.event.events.PluginTransactionStartEvent;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginTransactionListener
implements InitializingComponent {
    private static final Logger log = LoggerFactory.getLogger(PluginTransactionListener.class);
    private static final String LOG_PREFIX = "[plugin-transaction] ";
    static final int MAX_EVENTS_IN_TRANSACTION_LOGGED = 1000;
    private final EventPublisher eventPublisher;
    private final ReplicationPauserManager replicationPauserManager;
    private final ScheduledExecutorService executorService;
    final AtomicLong statsNumberStartEvents = new AtomicLong();
    final AtomicLong statsNumberEndEvents = new AtomicLong();
    final AtomicLong statsNumberSendEvents = new AtomicLong();
    final AtomicLong statsNumberEventsInTransactions = new AtomicLong();
    final AtomicLong statsNumberOfPluginEnableEvents = new AtomicLong();

    PluginTransactionListener(EventPublisher eventPublisher, ReplicationPauserManager replicationPauserManager, ScheduledExecutorService executorService, JiraProperties jiraProperties) {
        this.eventPublisher = eventPublisher;
        this.replicationPauserManager = replicationPauserManager;
        this.executorService = executorService;
        eventPublisher.register((Object)this);
        long statsFrequencyMin = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MINUTES);
        this.executorService.scheduleAtFixedRate(this::logStats, statsFrequencyMin, statsFrequencyMin, TimeUnit.MINUTES);
        log.info("[plugin-transaction] Created, registered for events and scheduled stats job every: {} min", (Object)statsFrequencyMin);
    }

    public PluginTransactionListener(EventPublisher eventPublisher, ReplicationPauserManager replicationPauserManager, JiraProperties jiraProperties) {
        this(eventPublisher, replicationPauserManager, Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("plugin-transaction-%d").build()), jiraProperties);
    }

    @Override
    public void afterInstantiation() throws Exception {
        log.info("[plugin-transaction] Initialized.");
    }

    @EventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        log.info("[plugin-transaction] Shutting down");
        this.executorService.shutdownNow();
    }

    synchronized void logStats() {
        try {
            log.info("[JIRA-STATS] [plugin-transaction] numberStartEvents:{}, numberEndEvents:{}, numberSendEvents:{}, numberEventsInTransactions:{}, numberOfPluginEnableEvents:{}", new Object[]{this.statsNumberStartEvents.get(), this.statsNumberEndEvents.get(), this.statsNumberSendEvents.get(), this.statsNumberEventsInTransactions.get(), this.statsNumberOfPluginEnableEvents.get()});
        }
        catch (Throwable throwable) {
            log.error("[plugin-transaction] Error in plugin transaction listener stats:{}", (Object)throwable.getMessage(), (Object)throwable);
        }
    }

    @EventListener(order=-2147483648)
    public void onPluginTransactionStartEvent(PluginTransactionStartEvent pluginTransactionStartEvent) {
        log.debug("[plugin-transaction] transaction starts with event:{}", (Object)pluginTransactionStartEvent.getClass().getSimpleName());
        this.statsNumberStartEvents.getAndIncrement();
    }

    @EventListener(order=-2147483648)
    @Deprecated
    public void onPluginEnabledEvent(PluginEnabledEvent pluginEnabledEvent) {
        log.debug("[plugin-transaction] plugin enabled event:{}", (Object)pluginEnabledEvent.getPlugin());
        this.statsNumberOfPluginEnableEvents.incrementAndGet();
        this.sendJiraPluginCacheResetEvent(JiraPluginCacheResetEvent.createFrom(pluginEnabledEvent));
    }

    @EventListener(order=-2147483648)
    public void onPluginTransactionStopEvent(PluginTransactionEndEvent pluginTransactionEndEvent) {
        if (log.isDebugEnabled()) {
            Object firstEvent = null;
            Object lastEvent = null;
            if (pluginTransactionEndEvent.numberOfEvents() > 0) {
                List eventsList = pluginTransactionEndEvent.getUnmodifiableEvents();
                firstEvent = eventsList.get(0);
                lastEvent = eventsList.get(eventsList.size() - 1);
            }
            log.debug("[plugin-transaction] transaction ends with event:{}, numberEventsInTransaction:{}, firstEvent:{}, lastEvent:{}", new Object[]{pluginTransactionEndEvent.getClass().getSimpleName(), pluginTransactionEndEvent.numberOfEvents(), firstEvent, lastEvent});
        }
        this.statsNumberEndEvents.incrementAndGet();
        if (pluginTransactionEndEvent.numberOfEvents() > 0) {
            this.statsNumberEventsInTransactions.addAndGet(pluginTransactionEndEvent.numberOfEvents());
            this.sendJiraPluginCacheResetEvent(new JiraPluginCacheResetEvent(pluginTransactionEndEvent));
        } else {
            log.trace("[plugin-transaction] Empty transaction.");
        }
    }

    private void sendJiraPluginCacheResetEvent(JiraPluginCacheResetEvent jiraPluginCacheResetEvent) {
        this.replicationPauserManager.pauseReplicationFor(() -> {
            this.eventPublisher.publish((Object)jiraPluginCacheResetEvent);
            this.statsNumberSendEvents.incrementAndGet();
        }, JiraPluginCacheResetEvent.class.getSimpleName());
        if (log.isTraceEnabled()) {
            String eventsInTransactionLogged = jiraPluginCacheResetEvent.getEvents().stream().map(o -> o.getClass().getSimpleName()).limit(1000L).collect(Collectors.joining(", "));
            String suffix = jiraPluginCacheResetEvent.getEvents().size() <= 1000 ? "." : "... and more.";
            log.trace("[plugin-transaction] {} events in transaction: {}", (Object)jiraPluginCacheResetEvent.numberOfEvents(), (Object)(eventsInTransactionLogged + suffix));
        }
    }
}

