/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.internal.util.PluginUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.util.FileAllowlistHelper;
import org.apache.velocity.runtime.resource.loader.util.FileTypeAllowlistHelper;
import org.apache.velocity.runtime.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginVelocityResourceLoader
extends ResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginVelocityResourceLoader.class);
    private static final Pattern PLUGINKEY_PREFIXED = Pattern.compile("([^:/]+):([^/:]+)/(.*)");
    private static final String FILETYPE_ALLOWLIST_PROPERTY_KEY = "plugin.resource.loader.filetype.allowlist";
    private FileAllowlistHelper fileAllowlistHelper = null;
    private FileTypeAllowlistHelper fileTypeAllowlistHelper = null;
    private List<String> trustedResourceProtocols = null;

    public void commonInit(RuntimeServices rs, ExtendedProperties configuration) {
        super.commonInit(rs, configuration);
        this.fileAllowlistHelper = new FileAllowlistHelper(this.rsvc);
        this.fileTypeAllowlistHelper = new FileTypeAllowlistHelper(this.rsvc, FILETYPE_ALLOWLIST_PROPERTY_KEY);
        this.trustedResourceProtocols = ConfigUtil.getStrings((RuntimeServices)this.rsvc, (String)"resource.loader.trusted.protocols");
        if (log.isTraceEnabled()) {
            log.trace("PluginVelocityResourceLoader : initialization complete.");
        }
    }

    public void init(ExtendedProperties configuration) {
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        PluginAccessor pluginAccessor = this.pluginAccessor();
        Matcher matcher = PLUGINKEY_PREFIXED.matcher(name);
        if (matcher.matches()) {
            URL resourceUrl;
            String pluginKey = matcher.group(1);
            String resourcePath = StringUtils.stripStart((String)matcher.group(3), (String)"/");
            Plugin plugin = pluginAccessor.getPlugin(pluginKey);
            if (plugin != null && (resourceUrl = plugin.getResource(resourcePath)) != null) {
                this.validateFileIsAllowed(resourceUrl, resourcePath);
                return plugin.getResourceAsStream(resourcePath);
            }
            name = resourcePath;
        }
        String resourceName = StringUtils.stripStart((String)name, (String)"/");
        URL resourceUrl = pluginAccessor.getClassLoader().getResource(resourceName);
        this.validateFileIsAllowed(resourceUrl, resourceName);
        return pluginAccessor.getDynamicResourceAsStream(resourceName);
    }

    private void validateFileIsAllowed(@Nullable URL resourceUrl, @Nonnull String name) throws ResourceNotFoundException {
        Objects.requireNonNull(name, "name");
        if (Objects.isNull(resourceUrl)) {
            return;
        }
        if (this.trustedResourceProtocols.contains(resourceUrl.getProtocol())) {
            return;
        }
        if (!this.fileTypeAllowlistHelper.isValidFileType(name)) {
            throw new ResourceNotFoundException("PluginVelocityResourceLoader : Banned file type on template " + name);
        }
        if (!this.fileAllowlistHelper.isAllowed(name)) {
            if (!PluginUtils.isAtlassianDevMode()) {
                throw new ResourceNotFoundException("PluginVelocityResourceLoader : This template is not allowed: " + name);
            }
            log.debug("This template is not in the allowlist, but it exists inside of the plugin so we'll let it slide in dev mode, template is {}", (Object)name);
        }
    }

    @VisibleForTesting
    PluginAccessor pluginAccessor() {
        return ComponentAccessor.getPluginAccessor();
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }

    public boolean isSourceModified(Resource resource) {
        return true;
    }
}

