/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.aboutpagepanel;

import com.atlassian.jira.license.thirdparty.BomParser;
import com.atlassian.jira.plugin.aboutpagepanel.AboutPagePanelModuleDescriptorImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BomParserImpl
implements BomParser {
    private static final Logger log = LoggerFactory.getLogger(BomParserImpl.class);

    @Override
    public List<AboutPagePanelModuleDescriptorImpl.Material> extractLgplMaterials(String bomContents) {
        ArrayList al = Lists.newArrayList();
        bomContents = bomContents.replaceAll("\\r", "\n");
        String[] materialLines = bomContents.split("\\n");
        for (String materialLine : materialLines = StringUtils.stripAll((String[])materialLines)) {
            String url;
            String mavenInfo;
            if (materialLine.startsWith("#") || !materialLine.contains("GNU Lesser General Public License")) continue;
            String[] materialInfo = materialLine.split(",", -1);
            if (materialInfo.length < 5) {
                log.warn(String.format("License info line '%s' could not be parsed because it has '%d' components, a minimum of 5 components is required", materialLine, materialInfo.length));
                continue;
            }
            String libraryName = (materialInfo = StringUtils.stripAll((String[])materialInfo))[0];
            if (StringUtils.isEmpty((CharSequence)(libraryName + (mavenInfo = materialInfo[1]) + (url = materialInfo[3])))) continue;
            String license = materialInfo[2];
            String artifactType = materialInfo[4];
            al.add(new AboutPagePanelModuleDescriptorImpl.Material(libraryName, mavenInfo, license, url, artifactType));
        }
        return al;
    }
}

