/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.decorator;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.plugin.PluginInjector;
import com.atlassian.jira.plugin.decorator.DecoratorModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoratorMapperModuleDescriptor
extends AbstractModuleDescriptor<DecoratorMapper> {
    private DecoratorMapper decoratorMapper;
    private static final Logger log = LoggerFactory.getLogger(DecoratorModuleDescriptor.class);

    public DecoratorMapperModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.attributeValue("class") == null) {
            throw new PluginParseException("decorator-mapper modules must have a class specified");
        }
    }

    public DecoratorMapper getModule() {
        return null;
    }

    @ClusterSafe(value="Local. We are just manipulating the sitemesh configuration in the local web app.")
    public synchronized DecoratorMapper getDecoratorMapper(Config config, DecoratorMapper parent) {
        if (this.decoratorMapper == null) {
            this.decoratorMapper = this.createDecoratorMapper();
            try {
                this.decoratorMapper.init(config, new Properties(), parent);
            }
            catch (InstantiationException ie) {
                log.error("Error initialising decorator mapper in plugin " + this.getKey(), (Throwable)ie);
                this.decoratorMapper = null;
            }
        }
        return this.decoratorMapper;
    }

    @VisibleForTesting
    DecoratorMapper createDecoratorMapper() {
        return (DecoratorMapper)PluginInjector.newInstance(this.getModuleClass(), this.plugin);
    }
}

