/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel3;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel3Adaptor;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.PaginatedIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.PaginatedIssueTabPanelAdaptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.Supplier;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueTabPanelModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<PaginatedIssueTabPanel>
implements IssueTabPanelModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(IssueTabPanelModuleDescriptorImpl.class);
    String label;
    private String labelKey;
    boolean isDefault = false;
    private int order;
    private boolean isSortable = false;
    private boolean supportsAjaxLoad;
    private Supplier<String> loadNewerLabel;
    private Supplier<String> loadOlderLabel;
    private Supplier<String> loadAllNewerLabel;
    private Supplier<String> loadAllOlderLabel;

    public IssueTabPanelModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.label = element.element("label").getTextTrim();
        this.labelKey = element.element("label").attributeValue("key");
        this.isDefault = IssueTabPanelModuleDescriptorImpl.getBooleanElement(element, "default");
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
        this.isSortable = IssueTabPanelModuleDescriptorImpl.getBooleanElement(element, "sortable");
        this.supportsAjaxLoad = IssueTabPanelModuleDescriptorImpl.getBooleanElement(element, "supports-ajax-load");
        this.loadNewerLabel = this.i18nLabel(element.element("show-newer-expander-label"));
        this.loadOlderLabel = this.i18nLabel(element.element("show-older-expander-label"));
        this.loadAllNewerLabel = this.i18nLabel(element.element("show-all-newer-expander-label"));
        this.loadAllOlderLabel = this.i18nLabel(element.element("show-all-older-expander-label"));
    }

    @Override
    public void enabled() {
        super.enabled();
    }

    private static boolean getBooleanElement(Element parentElement, String elementName) {
        Element element = parentElement.element(elementName);
        if (element == null) {
            return false;
        }
        String isDefaultText = element.getTextTrim();
        return isDefaultText != null && Boolean.valueOf(isDefaultText) != false;
    }

    public String getLabel() {
        if (this.labelKey != null) {
            return this.getI18nBean().getText(this.labelKey);
        }
        return this.label;
    }

    @Override
    protected PaginatedIssueTabPanel createModule() {
        PaginatedIssueTabPanel issueTabPanel;
        Object module = this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        if (module instanceof PaginatedIssueTabPanel) {
            issueTabPanel = (PaginatedIssueTabPanel)module;
        } else if (module instanceof IssueTabPanel) {
            issueTabPanel = PaginatedIssueTabPanelAdaptor.createFrom(IssueTabPanel3Adaptor.createFrom((IssueTabPanel)module));
        } else if (module instanceof IssueTabPanel3) {
            issueTabPanel = PaginatedIssueTabPanelAdaptor.createFrom((IssueTabPanel3)module);
        } else {
            throw new ClassCastException("Class " + module.getClass().getCanonicalName() + " is not a legal class for issue tab panel plugin point.");
        }
        issueTabPanel.init((IssueTabPanelModuleDescriptor)this);
        return issueTabPanel;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isSortable() {
        return this.isSortable;
    }

    public boolean isSupportsAjaxLoad() {
        return this.supportsAjaxLoad;
    }

    public String getLoadNewerLabel() {
        return (String)this.loadNewerLabel.get();
    }

    public String getLoadOlderLabel() {
        return (String)this.loadOlderLabel.get();
    }

    public String getLoadAllNewerLabel() {
        return (String)this.loadAllNewerLabel.get();
    }

    public String getLoadAllOlderLabel() {
        return (String)this.loadAllOlderLabel.get();
    }

    private Supplier<String> i18nLabel(Element element) {
        String text = Optional.ofNullable(element).map(Element::getTextTrim).orElse(null);
        String i18nKey = Optional.ofNullable(element).map(e -> e.attributeValue("key")).orElse(null);
        return () -> i18nKey != null ? this.getI18nBean().getText(i18nKey) : text;
    }
}

