/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.language;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.language.Language;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.opensymphony.util.TextUtils;

public class LanguageModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<Language>
implements LanguageModuleDescriptor {
    private String encoding;
    private String language;
    private String country;
    private String variant;

    public LanguageModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.attributeValue("language") == null || !TextUtils.stringSet((String)element.attributeValue("language"))) {
            throw new PluginParseException("Module " + this.getCompleteKey() + " must define a \"language\" attribute");
        }
        if (element.attributeValue("language") != null) {
            this.setLanguage(element.attributeValue("language"));
        }
        if (element.attributeValue("country") != null) {
            this.setCountry(element.attributeValue("country"));
        }
        if (element.attributeValue("variant") != null) {
            this.setVariant(element.attributeValue("variant"));
        }
        if (element.attributeValue("encoding") != null) {
            this.setEncoding(element.attributeValue("encoding"));
        }
    }

    @Override
    protected Language createModule() {
        return new Language((LanguageModuleDescriptor)this);
    }

    public String getResourceBundleName() {
        return DefaultResourceBundle.DEFAULT_RESOURCE_BUNDLE_NAME;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }
}

