/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.myjirahome;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomeLinker;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomePreference;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.model.WebLink;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class MyJiraHomeLinkerImpl
implements MyJiraHomeLinker {
    private static final String CONTEXT_KEY_USER = "user";
    private static final String CONTEXT_KEY_HELPER = "helper";
    private final PluginAccessor pluginAccessor;
    private final MyJiraHomePreference myJiraHomePreference;
    private final ProjectService projectService;

    public MyJiraHomeLinkerImpl(@Nonnull PluginAccessor pluginAccessor, @Nonnull MyJiraHomePreference myJiraHomePreference, @Nonnull ProjectService projectService) {
        this.pluginAccessor = pluginAccessor;
        this.myJiraHomePreference = myJiraHomePreference;
        this.projectService = projectService;
    }

    @Override
    @Nonnull
    public String getHomeLink(@Nullable ApplicationUser user) {
        String completePluginModuleKey = this.myJiraHomePreference.findHome(user);
        try {
            if (StringUtils.isEmpty((CharSequence)completePluginModuleKey)) {
                return this.hasPublicAccess(user) ? DEFAULT_HOME_NOT_ANON : DEFAULT_HOME_OD_ANON;
            }
            if (!this.pluginAccessor.isPluginModuleEnabled(completePluginModuleKey)) {
                return DEFAULT_HOME_NOT_ANON;
            }
            WebLink link = this.getWebLinkFromWebItemModuleDescriptor(completePluginModuleKey, user);
            if (link != null) {
                return link.getRenderedUrl(Collections.emptyMap());
            }
            return DEFAULT_HOME_NOT_ANON;
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_HOME_NOT_ANON;
        }
    }

    @Nullable
    private WebLink getWebLinkFromWebItemModuleDescriptor(@Nonnull String completePluginModuleKey, @Nullable ApplicationUser user) {
        WebItemModuleDescriptor webItemModuleDescriptor = this.getWebItemModuleDescriptorFromKey(completePluginModuleKey);
        if (webItemModuleDescriptor != null && this.isConditionSatisfied(webItemModuleDescriptor, user)) {
            return webItemModuleDescriptor.getLink();
        }
        return null;
    }

    @Nullable
    private WebItemModuleDescriptor getWebItemModuleDescriptorFromKey(@Nonnull String completePluginModuleKey) {
        ModuleDescriptor pluginModule = this.pluginAccessor.getPluginModule(completePluginModuleKey);
        if (pluginModule instanceof WebItemModuleDescriptor) {
            return (WebItemModuleDescriptor)pluginModule;
        }
        return null;
    }

    private boolean isConditionSatisfied(@Nonnull WebItemModuleDescriptor webItemModuleDescriptor, @Nullable ApplicationUser user) {
        Condition condition = webItemModuleDescriptor.getCondition();
        if (condition == null) {
            return true;
        }
        return condition.shouldDisplay(this.createContext(user));
    }

    private Map<String, Object> createContext(@Nullable ApplicationUser user) {
        JiraHelper jiraHelper = new JiraHelper(ExecutingHttpRequest.get());
        HashMap context = Maps.newHashMap((Map)jiraHelper.getContextParams());
        context.put(CONTEXT_KEY_USER, user);
        context.put(CONTEXT_KEY_HELPER, jiraHelper);
        return context;
    }

    private boolean hasPublicAccess(ApplicationUser user) {
        return ((PermissionManager)ComponentAccessor.getComponent(PermissionManager.class)).hasPublicAccess(user);
    }

    @Override
    @Nonnull
    public String getDefaultUserHome() {
        return DEFAULT_HOME_NOT_ANON;
    }
}

