/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.navigation;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LnFDefaultColorProvider;
import com.atlassian.jira.config.properties.LogoProvider;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.external.ExternalRuntimeException;
import com.atlassian.jira.plugin.navigation.LfColor;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.web.util.CssSubstitutionWebResourceTransformer;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LfStylesService {
    private static final String COLON_SPACE = ": ";
    private static final String JIRA_COLOR_SCHEME = "--jira-color-";
    private static final String SEMICOLON_ENTER = ";\n";
    private final ApplicationProperties applicationProperties;
    private final WebResourceIntegration webResourceIntegration;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final LnFDefaultColorProvider lnFDefaultColorProvider;
    private final LogoProvider logoProvider;

    public LfStylesService(ApplicationProperties applicationProperties, WebResourceIntegration webResourceIntegration, LnFDefaultColorProvider lnFDefaultColorProvider, SoyTemplateRendererProvider soyTemplateRendererProvider, LogoProvider logoProvider) {
        this.applicationProperties = applicationProperties;
        this.webResourceIntegration = webResourceIntegration;
        this.soyTemplateRenderer = soyTemplateRendererProvider.getRenderer();
        this.lnFDefaultColorProvider = lnFDefaultColorProvider;
        this.logoProvider = logoProvider;
    }

    public String prepareLookAndFeelColorsCss() {
        LookAndFeelBean laf = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties, (LnFDefaultColorProvider)this.lnFDefaultColorProvider, (LogoProvider)this.logoProvider);
        Map<String, String> variableMap = new CssSubstitutionWebResourceTransformer.VariableMap(laf, this.webResourceIntegration).getVariableMap(false);
        HashMap<String, List<String>> context = new HashMap<String, List<String>>();
        context.put("originalThemeVariables", this.generateCssProperties(variableMap));
        context.put("darkThemeVariables", this.generateCssProperties(null));
        try {
            return this.soyTemplateRenderer.render("jira.webresources:soy-templates", "JIRA.Templates.DarkThemeStyles.lookAndFeelDarkThemeStyles", context);
        }
        catch (SoyException e) {
            throw new ExternalRuntimeException(e);
        }
    }

    private List<String> generateCssProperties(Map<String, String> variableMap) {
        ArrayList<String> cssProperties = new ArrayList<String>();
        for (LfColor color : LfColor.values()) {
            String label = color.getLabel();
            String cssProperty = JIRA_COLOR_SCHEME + label + COLON_SPACE;
            cssProperty = variableMap != null ? cssProperty + variableMap.get(label) + SEMICOLON_ENTER : cssProperty + color.getDtProperty() + SEMICOLON_ENTER;
            cssProperties.add(cssProperty);
        }
        return cssProperties;
    }
}

