/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.osgi;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.config.ConfigParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class OsgiConfigListReader {
    private static final String RESOURCES_PATH = "osgi/";
    private static final Predicate<String> FILTER = line -> StringUtils.isNotBlank((CharSequence)line) && !StringUtils.startsWith((CharSequence)line, (CharSequence)"#");

    private OsgiConfigListReader() {
    }

    public static Set<String> readToSet(String exportsFile) {
        Set set;
        block8: {
            String filePath = RESOURCES_PATH + exportsFile;
            InputStream stream = ClassLoaderUtils.getResourceAsStream((String)filePath, OsgiConfigListReader.class);
            try {
                set = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8).stream().filter(FILTER).flatMap(line -> Arrays.stream(StringUtils.split((String)line, (String)","))).map(String::trim).collect(Collectors.toCollection(HashSet::new));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigParseException("Failed to read the OSGI config file: " + exportsFile, e);
                }
            }
            stream.close();
        }
        return set;
    }

    public static List<String> readToList(String exportsFile) {
        return new ArrayList<String>(OsgiConfigListReader.readToSet(exportsFile));
    }
}

