/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.renderer;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.issue.util.RendererWebPanelRenderUtil;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ServletActionContext;

public class JiraRendererModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<JiraRendererPlugin>
implements JiraRendererModuleDescriptor {
    public static final String TEMPLATE_NAME_CSS = "css";
    public static final String TEMPLATE_NAME_JS = "javascript";
    public static final String TEMPLATE_NAME_EDIT = "edit";
    public static final String WEB_PANELS_LOCATION = "web-panels-location";
    private ApplicationProperties applicationProperties;
    private ModuleWebComponent moduleWebComponent;
    private DynamicWebInterfaceManager webInterfaceManager;
    private IssueManager issueManager;
    private String webPanelsLocation;

    public JiraRendererModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, ModuleFactory moduleFactory, ModuleWebComponent moduleWebComponent, DynamicWebInterfaceManager webInterfaceManager, IssueManager issueManager) {
        super(authenticationContext, moduleFactory);
        this.applicationProperties = applicationProperties;
        this.moduleWebComponent = moduleWebComponent;
        this.webInterfaceManager = webInterfaceManager;
        this.issueManager = issueManager;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.webPanelsLocation = element.attributeValue(WEB_PANELS_LOCATION);
    }

    public String getCss() {
        HashMap<String, String> params = new HashMap<String, String>();
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        params.put("menuTxtColour", lookAndFeelBean.getMenuTxtColour());
        params.put("textHighlightColour", lookAndFeelBean.getTextHeadingColour());
        params.put("menuBackgroundColour", lookAndFeelBean.getMenuBackgroundColour());
        params.put("req", (String)ServletActionContext.getRequest());
        return this.getHtml(TEMPLATE_NAME_CSS, params);
    }

    public String getJavaScript(String contextPath) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("i18n", this.getI18nBean());
        params.put("contextPath", contextPath);
        return this.getHtml(TEMPLATE_NAME_JS, params);
    }

    public String getEditVM(String value, String issueKey, String rendererType, String fieldId, String fieldName, Map params, boolean singleLine) {
        if (!this.isResourceExist(TEMPLATE_NAME_EDIT)) {
            throw new IllegalStateException("An edit velocity template is a required resource for a renderer module.");
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        JiraRendererPlugin renderer = (JiraRendererPlugin)this.getModule();
        HttpServletRequest request = ServletActionContext.getRequest();
        params.put("req", request);
        params.put("fieldId", fieldId);
        params.put("fieldName", fieldName);
        params.put("issueKey", issueKey);
        params.put("rendererType", renderer.getRendererType());
        params.put("value", renderer.transformForEdit((Object)value));
        params.put("textutils", new TextUtils());
        params.put("i18n", this.getI18nBean());
        if (singleLine) {
            params.put("singleLine", Boolean.TRUE);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.webPanelsLocation)) {
            MutableIssue issue = this.issueManager.getIssueObject(issueKey);
            RendererWebPanelRenderUtil rteInitWebPanelRenderUtil = new RendererWebPanelRenderUtil(this.getAuthenticationContext().getLoggedInUser(), value, issueKey, (Issue)issue, fieldId, fieldName, singleLine, this.webInterfaceManager, this.moduleWebComponent, renderer, Optional.ofNullable(request).map(ServletRequest::getParameterMap).orElse((Map)ImmutableMap.of()));
            params.put("webPanelsContent", rteInitWebPanelRenderUtil.renderPanels(rteInitWebPanelRenderUtil.getWebPanels(this.webPanelsLocation)));
        }
        Object editHtml = this.getHtml(TEMPLATE_NAME_EDIT, params);
        if (!renderer.getRendererType().equals(rendererType) && rendererType != null && !"null".equals(rendererType)) {
            editHtml = this.getI18nBean().getText("renderer.not.available.message", rendererType, this.getName()) + (String)editHtml;
        }
        return editHtml;
    }

    public boolean isCSSTemplateExists() {
        return this.isResourceExist(TEMPLATE_NAME_CSS);
    }

    public boolean isJavaScriptTemplateExists() {
        return this.isResourceExist(TEMPLATE_NAME_JS);
    }

    public boolean isEditTemplateExists() {
        return this.isResourceExist(TEMPLATE_NAME_EDIT);
    }
}

