/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.report.ReportSubTaskFetcher;
import com.atlassian.jira.plugin.report.SubTaskInclusionOption;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReportSubTaskFetcher
implements ReportSubTaskFetcher {
    private static final Logger log = LoggerFactory.getLogger(ReportSubTaskFetcher.class);
    private final SearchService searchService;

    public DefaultReportSubTaskFetcher(SearchService searchService) {
        this.searchService = searchService;
    }

    public List<Issue> getSubTasks(ApplicationUser user, List<Issue> parentIssues, SubTaskInclusionOption subtaskInclusion, boolean onlyIncludeUnresolved) throws SearchException {
        return this.getSubTasks(user, parentIssues, subtaskInclusion, onlyIncludeUnresolved, Integer.MAX_VALUE);
    }

    public List<Issue> getSubTasks(ApplicationUser user, List<Issue> parentIssues, SubTaskInclusionOption subtaskInclusion, boolean onlyIncludeUnresolved, int limit) throws SearchException {
        if (subtaskInclusion == null || subtaskInclusion.equals((Object)SubTaskInclusionOption.ONLY_SELECTED_VERSION)) {
            return Collections.emptyList();
        }
        if (parentIssues == null || parentIssues.isEmpty()) {
            return Collections.emptyList();
        }
        JqlClauseBuilder queryBuilder = this.getQueryForSubTasks(parentIssues, onlyIncludeUnresolved);
        if (subtaskInclusion.equals((Object)SubTaskInclusionOption.SELECTED_AND_BLANK_VERSIONS)) {
            queryBuilder.and().fixVersionIsEmpty();
        }
        SearchResults subtaskSearchResults = this.searchService.search(user, queryBuilder.buildQuery(), new PagerFilter(limit));
        return subtaskSearchResults.getResults();
    }

    public List<Issue> getSubTasksForUser(ApplicationUser user, List<Issue> parentIssues, SubTaskInclusionOption subtaskInclusion, boolean onlyIncludeUnresolved) throws SearchException {
        if (subtaskInclusion == null || subtaskInclusion.equals((Object)SubTaskInclusionOption.ONLY_ASSIGNED)) {
            return Collections.emptyList();
        }
        if (!subtaskInclusion.equals((Object)SubTaskInclusionOption.ASSIGNED_AND_UNASSIGNED)) {
            log.info("Unknown Subtask Inclusion parameter: " + subtaskInclusion);
            return Collections.emptyList();
        }
        if (parentIssues == null || parentIssues.isEmpty()) {
            return Collections.emptyList();
        }
        JqlClauseBuilder whereClauseBuilder = this.getQueryForSubTasks(parentIssues, onlyIncludeUnresolved);
        whereClauseBuilder.and().assigneeIsEmpty();
        SearchResults subtaskSearchResults = this.searchService.search(user, whereClauseBuilder.buildQuery(), new PagerFilter(Integer.MAX_VALUE));
        return subtaskSearchResults.getResults();
    }

    private JqlClauseBuilder getQueryForSubTasks(List<Issue> parentIssues, boolean onlyIncludeUnresolved) {
        List parentIssueIds = parentIssues.stream().filter(Objects::nonNull).map(Issue::getId).collect(Collectors.toList());
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().issueParent().inNumbers(parentIssueIds);
        if (onlyIncludeUnresolved) {
            builder = builder.and().unresolved();
        }
        return builder;
    }
}

