/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.plugin.AbstractConfigurableModuleDescriptor;
import com.atlassian.jira.plugin.PluginInjector;
import com.atlassian.jira.plugin.report.Report;
import com.atlassian.jira.plugin.report.ReportCategory;
import com.atlassian.jira.plugin.report.ReportCategoryImpl;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.plugin.report.ReportUrlProvider;
import com.atlassian.jira.plugin.webfragment.descriptors.ConditionDescriptorFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Functions;
import io.atlassian.fugue.Option;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;

public class ReportModuleDescriptorImpl
extends AbstractConfigurableModuleDescriptor<Report>
implements ReportModuleDescriptor,
ConditionalDescriptor {
    public static final String PARAMS_PATTERN = "{0}?selectedProjectId={1,number,#}&projectOrFilterId=project-{1,number,#}&projectOrFilterName={2}&reportKey={3}";
    public static final int DEFAULT_WEIGHT = 1000;
    public static final String DEFAULT_THUMBNAIL_CSS_CLASS = "default-thumbnail";
    private Report report;
    private String label = "Unknown";
    private String url = "/secure/ConfigureReport!default.jspa";
    private String labelKey;
    private ReportCategory category = ReportCategoryImpl.OTHER;
    private String thumbnailCssClass = "default-thumbnail";
    private String configurationRemarksKey;
    private String configurationRemarksHeaderKey;
    private String learnMoreLinkURLKey;
    private int weight = 1000;
    private String urlProviderClass;
    private ReportUrlProvider urlProvider;
    private Condition condition;
    private boolean singleton;
    private final ConditionDescriptorFactory conditionDescFactory;

    @Deprecated
    public ReportModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        this(authenticationContext, moduleFactory, (ConditionDescriptorFactory)ComponentAccessor.getComponent(ConditionDescriptorFactory.class));
    }

    public ReportModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, ConditionDescriptorFactory conditionDescFactory) {
        super(authenticationContext, moduleFactory);
        this.conditionDescFactory = conditionDescFactory;
    }

    protected boolean isSingletonByDefault() {
        return false;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        String value;
        String clazz;
        Element categoryEl;
        Element urlEl;
        super.init(plugin, element);
        Element labelEl = element.element("label");
        if (labelEl != null) {
            if (labelEl.attributeValue("key") != null) {
                this.labelKey = labelEl.attributeValue("key");
            } else {
                this.label = labelEl.getTextTrim();
            }
        }
        if ((urlEl = element.element("url")) != null) {
            String stringUrl = urlEl.getTextTrim();
            if (StringUtils.isNotBlank((CharSequence)stringUrl)) {
                this.url = stringUrl;
            }
            this.urlProviderClass = StringUtils.trimToNull((String)urlEl.attributeValue("provider"));
        }
        if ((categoryEl = element.element("category")) != null) {
            String categoryKey = StringUtils.trimToNull((String)categoryEl.attributeValue("key"));
            ReportCategory reportCategory = ReportCategoryImpl.byKey(categoryKey);
            if (reportCategory != null) {
                this.category = reportCategory;
            } else {
                throw new PluginParseException(String.format("The report module: %s specified a category key that is not a valid category: %s", this.getCompleteKey(), categoryKey));
            }
        }
        try {
            String weightString = StringUtils.trimToNull((String)element.attributeValue("weight"));
            if (weightString != null) {
                this.weight = Integer.parseInt(weightString);
            }
        }
        catch (NumberFormatException e) {
            throw new PluginParseException(String.format("The report module: %s specified a weight attribute that is not an integer", this.getCompleteKey()), (Throwable)e);
        }
        Element thumbnail = element.element("thumbnail");
        if (thumbnail != null && (clazz = StringUtils.trimToNull((String)thumbnail.attributeValue("cssClass"))) != null) {
            this.thumbnailCssClass = clazz;
        }
        this.singleton = (value = element.attributeValue("singleton")) != null ? Boolean.parseBoolean(value) : this.isSingletonByDefault();
        this.condition = this.conditionDescFactory.retrieveCondition(plugin, element);
        Element configurationRemarksEl = element.element("configuration-remarks");
        if (configurationRemarksEl != null) {
            this.configurationRemarksKey = StringUtils.trimToNull((String)configurationRemarksEl.attributeValue("key"));
            this.configurationRemarksHeaderKey = StringUtils.trimToNull((String)configurationRemarksEl.attributeValue("header-key"));
            this.learnMoreLinkURLKey = StringUtils.trimToNull((String)configurationRemarksEl.attributeValue("learn-more-link-URL-key"));
        }
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(Report.class);
        if (this.urlProviderClass != null && this.urlProvider == null) {
            try {
                Class loadedClass = this.plugin.loadClass(this.urlProviderClass, ((Object)((Object)this)).getClass());
                if (!ReportUrlProvider.class.isAssignableFrom(loadedClass)) {
                    throw new PluginParseException("Provided class " + this.urlProviderClass + " does not implement ReportUrlProvider interface");
                }
                try {
                    this.urlProvider = (ReportUrlProvider)PluginInjector.newInstance(loadedClass, this.plugin);
                }
                catch (Exception e) {
                    throw new PluginParseException("Cannot instantiate url provider class: " + this.urlProviderClass, (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Cannot load url provider class: " + this.urlProviderClass, (Throwable)e);
            }
        }
    }

    @Override
    public Report getModule() {
        if (!this.isSingleton()) {
            return this.makeModule();
        }
        if (this.report == null) {
            this.report = this.makeModule();
        }
        return this.report;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    private Report makeModule() {
        Plugin plugin = this.getPlugin();
        Report reportModule = plugin instanceof ContainerManagedPlugin ? (Report)((ContainerManagedPlugin)plugin).getContainerAccessor().createBean(this.getModuleClass()) : (Report)ComponentManager.getInstance().loadComponent(this.getModuleClass(), Collections.emptyList());
        reportModule.init((ReportModuleDescriptor)this);
        return reportModule;
    }

    public String getLabel() {
        if (this.labelKey != null) {
            return this.getI18nBean().getText(this.labelKey);
        }
        return this.label;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public String getUrl(Project context) {
        return (String)this.getUrl((Map<String, Object>)ImmutableMap.of((Object)"project", (Object)context)).getOrNull();
    }

    public Option<String> getUrl(final Map<String, Object> context) {
        if (this.urlProvider != null) {
            return Option.option((Object)((Option)SafePluginPointAccess.call((Callable)new Callable<Option<String>>(){

                @Override
                public Option<String> call() throws Exception {
                    return ReportModuleDescriptorImpl.this.urlProvider.getUrl((ReportModuleDescriptor)ReportModuleDescriptorImpl.this, context);
                }
            }).getOrNull())).flatMap(Functions.identity());
        }
        Project project = (Project)context.get("project");
        return Option.option((Object)MessageFormat.format(PARAMS_PATTERN, this.url, project.getId(), project.getName(), this.getCompleteKey()));
    }

    public ReportCategory getCategory() {
        return this.category;
    }

    public String getThumbnailCssClass() {
        return this.thumbnailCssClass;
    }

    public Optional<String> getConfigurationRemarks() {
        if (this.configurationRemarksKey != null) {
            return Optional.of(this.getI18nBean().getText(this.configurationRemarksKey));
        }
        return Optional.empty();
    }

    public Optional<String> getConfigurationRemarksHeader() {
        if (this.configurationRemarksHeaderKey != null) {
            return Optional.of(this.getI18nBean().getText(this.configurationRemarksHeaderKey));
        }
        return Optional.empty();
    }

    public Optional<String> getLearnMoreLinkURL() {
        if (this.learnMoreLinkURLKey != null) {
            return Optional.of(this.getI18nBean().getText(this.learnMoreLinkURLKey));
        }
        return Optional.empty();
    }

    public int getWeight() {
        return this.weight;
    }

    public Condition getCondition() {
        return this.condition;
    }
}

