/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview;

import com.atlassian.core.util.XMLUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.event.ExportEvent;
import com.atlassian.jira.issue.export.customfield.DelimiterResolver;
import com.atlassian.jira.issue.search.ClauseTooComplexSearchException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestFactory;
import com.atlassian.jira.issue.search.SearchRequestInfo;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.transport.impl.ActionParamsImpl;
import com.atlassian.jira.issue.views.util.RssViewUtils;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.plugin.issueview.IssueViewFieldParams;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParamsHelper;
import com.atlassian.jira.plugin.searchrequestview.HttpRequestHeaders;
import com.atlassian.jira.plugin.searchrequestview.RequestHeaders;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParamsImpl;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestURLHandler;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestViewAccessErrorHandler;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestViewModuleDescriptor;
import com.atlassian.jira.plugin.searchrequestview.auth.Authorizer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.oauth.util.RequestAnnotations;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.seraph.util.RedirectUtils;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class DefaultSearchRequestURLHandler
implements SearchRequestURLHandler {
    private static final String SAMPLE_URL = "/sr/jira.issueviews:searchrequest-xml/10010/SearchRequest-10010.xml OR /sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?param1=abc&param2=xyz";
    private static final String INCORRECT_PARAMS_MESSAGE = "You can't use raw RSS mode together with no response headers";
    private static final String INVALID_PATH_FORMAT_MESSAGE = "Invalid path format. Path should be of format ";
    private static final String NOT_FOUND_MODULE_MESSAGE = "Could not find any enabled plugin with key ";
    private static final String XML_MODULE_NAME = "XML";
    private static final String VALIDATE_PARAM = "validateQuery";
    private final PluginAccessor pluginAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18n;
    private final Authorizer requestAuthorizer;
    private final IssueViewRequestParamsHelper issueViewRequestParamsHelper;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final SearchService searchService;
    private final JqlStringSupport jqlStringSupport;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final BuildUtilsInfo buildUtilsInfo;
    private final EventPublisher eventPublisher;
    private final DelimiterResolver delimiterResolver;

    public DefaultSearchRequestURLHandler(PluginAccessor pluginAccessor, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nBean, Authorizer requestAuthorizer, IssueViewRequestParamsHelper issueViewRequestParamsHelper, SearchService searchService, JqlStringSupport jqlStringSupport, BuildUtilsInfo buildUtilsInfo, DateTimeFormatterFactory dateTimeFormatterFactory, EventPublisher eventPublisher, DelimiterResolver delimiterResolver) {
        this.pluginAccessor = pluginAccessor;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.i18n = i18nBean;
        this.requestAuthorizer = requestAuthorizer;
        this.issueViewRequestParamsHelper = issueViewRequestParamsHelper;
        this.searchService = searchService;
        this.jqlStringSupport = jqlStringSupport;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.velocityRequestContextFactory = new DefaultVelocityRequestContextFactory(applicationProperties);
        this.eventPublisher = eventPublisher;
        this.delimiterResolver = delimiterResolver;
    }

    @Override
    public String getURLWithoutContextPath(SearchRequestViewModuleDescriptor moduleDescriptor, SearchRequestInfo searchRequestInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("/sr/");
        sb.append(moduleDescriptor.getCompleteKey());
        Long searchRequestId = searchRequestInfo.getId();
        if (searchRequestId != null && !searchRequestInfo.isModified()) {
            sb.append("/");
            sb.append(searchRequestId);
            sb.append("/SearchRequest-");
            sb.append(searchRequestId);
            sb.append(".");
            sb.append(moduleDescriptor.getFileExtension());
        } else {
            sb.append("/temp/SearchRequest.");
            sb.append(moduleDescriptor.getFileExtension());
            sb.append("?");
            String queryString = this.getQueryString(searchRequestInfo);
            if (queryString.indexOf("&") == 0) {
                queryString = queryString.substring(1);
            }
            sb.append(queryString);
        }
        return sb.toString();
    }

    private String getQueryString(SearchRequestInfo searchRequest) {
        return this.searchService.getQueryString(this.authenticationContext.getUser(), (Query)(searchRequest == null ? new QueryImpl() : searchRequest.getQuery()));
    }

    private static String getSampleURL() {
        return SAMPLE_URL;
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Authorizer.Result result;
        long resultCount;
        MessageSet messageSet;
        SearchRequest searchRequest;
        int firstSlashLocation;
        String pathInfo = request.getPathInfo();
        if (StringUtils.isBlank((CharSequence)pathInfo)) {
            response.sendError(400, INVALID_PATH_FORMAT_MESSAGE + DefaultSearchRequestURLHandler.getSampleURL());
            return;
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        if ((firstSlashLocation = pathInfo.indexOf("/")) == -1) {
            response.sendError(400, INVALID_PATH_FORMAT_MESSAGE + DefaultSearchRequestURLHandler.getSampleURL());
            return;
        }
        String pluginKey = pathInfo.substring(0, firstSlashLocation);
        int secondSlashLocation = pathInfo.indexOf("/", firstSlashLocation + 1);
        if (secondSlashLocation == -1) {
            response.sendError(400, INVALID_PATH_FORMAT_MESSAGE + DefaultSearchRequestURLHandler.getSampleURL());
            return;
        }
        if ("true".equalsIgnoreCase(request.getParameter("noResponseHeaders")) && "raw".equalsIgnoreCase(request.getParameter("rssMode"))) {
            response.sendError(400, INCORRECT_PARAMS_MESSAGE);
            return;
        }
        SearchRequestViewModuleDescriptor moduleDescriptor = null;
        try {
            moduleDescriptor = (SearchRequestViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(pluginKey);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (moduleDescriptor == null) {
            response.sendError(400, NOT_FOUND_MODULE_MESSAGE + pluginKey);
            return;
        }
        SearchRequestView view = moduleDescriptor.getSearchRequestView();
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        String betweenSlashes = pathInfo.substring(firstSlashLocation + 1, secondSlashLocation);
        IssueViewFieldParams issueViewFieldParams = this.issueViewRequestParamsHelper.getIssueViewFieldParams(request.getParameterMap());
        if (betweenSlashes.startsWith("temp")) {
            Map parameters = request.getParameterMap();
            String jqlQueryString = this.getJqlQueryString(parameters);
            if (jqlQueryString != null) {
                SearchService.ParseResult jqlQueryResult = this.searchService.parseQuery(loggedInUser, jqlQueryString);
                Query query = null;
                if (jqlQueryResult != null) {
                    if (!this.isValidateJql(request) || jqlQueryResult.isValid()) {
                        query = jqlQueryResult.getQuery();
                    } else {
                        response.sendError(400, (String)jqlQueryResult.getErrors().getErrorMessages().iterator().next());
                        return;
                    }
                }
                searchRequest = this.getSearchRequestFactory().createFromQuery(null, loggedInUser, query);
            } else {
                searchRequest = this.getSearchRequestFactory().createFromParameters(null, loggedInUser, new ActionParamsImpl(parameters));
            }
            if (searchRequest == null) {
                response.sendError(500, this.i18n.getInstance(this.authenticationContext.getLocale()).getText("search.request.invalid"));
                return;
            }
            if (issueViewFieldParams.isCustomViewRequested() && !issueViewFieldParams.isAnyFieldDefined()) {
                response.sendError(400, "No valid field defined for issue custom view");
                return;
            }
        } else {
            try {
                Long searchRequestId = new Long(betweenSlashes);
                searchRequest = this.getSearchRequestService().getFilter((JiraServiceContext)new JiraServiceContextImpl(loggedInUser), searchRequestId);
            }
            catch (NumberFormatException searchRequestIdIsNotALongValue) {
                searchRequest = null;
            }
            if (searchRequest == null) {
                SearchRequestViewAccessErrorHandler searchRequestViewAccessErrorHandler;
                if (XML_MODULE_NAME.equals(moduleDescriptor.getName())) {
                    this.writeDummyXMLResponse(response);
                    return;
                }
                if (Users.isAnonymous((ApplicationUser)loggedInUser) && moduleDescriptor.isBasicAuthenticationRequired()) {
                    this.redirectToBasicAuthentication(request, response);
                    return;
                }
                if (Users.isAnonymous((ApplicationUser)loggedInUser)) {
                    if (view instanceof SearchRequestViewAccessErrorHandler) {
                        searchRequestViewAccessErrorHandler = (SearchRequestViewAccessErrorHandler)view;
                        searchRequestViewAccessErrorHandler.writeErrorHeaders((RequestHeaders)new HttpRequestHeaders(response));
                        BufferedWriter writer = new BufferedWriter(response.getWriter());
                        searchRequestViewAccessErrorHandler.writePermissionViolationError(writer);
                        writer.flush();
                    } else {
                        response.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
                    }
                    return;
                }
                if (loggedInUser != null && moduleDescriptor.isBasicAuthenticationRequired()) {
                    response.sendError(403, this.i18n.getInstance(this.authenticationContext.getLocale()).getText("search.request.invalid.permission"));
                    return;
                }
                if (view instanceof SearchRequestViewAccessErrorHandler) {
                    searchRequestViewAccessErrorHandler = (SearchRequestViewAccessErrorHandler)view;
                    searchRequestViewAccessErrorHandler.writeErrorHeaders((RequestHeaders)new HttpRequestHeaders(response));
                    BufferedWriter writer = new BufferedWriter(response.getWriter());
                    searchRequestViewAccessErrorHandler.writeSearchRequestDoesNotExistError(writer);
                    writer.flush();
                } else {
                    this.loadJsp(request, response, "/secure/views/searchrequesterror.jsp");
                }
                return;
            }
            SearchSortUtil searchSortUtil = (SearchSortUtil)ComponentAccessor.getComponentOfType(SearchSortUtil.class);
            OrderBy orderByFromParams = searchSortUtil.getOrderByClause(request.getParameterMap());
            Object orderBy = searchRequest.getQuery().getOrderByClause() != null ? new OrderByImpl((Collection)searchSortUtil.mergeSearchSorts(loggedInUser, (Collection)orderByFromParams.getSearchSorts(), (Collection)searchRequest.getQuery().getOrderByClause().getSearchSorts(), Integer.MAX_VALUE)) : orderByFromParams;
            searchRequest.setQuery((Query)new QueryImpl(searchRequest.getQuery().getWhereClause(), orderBy, searchRequest.getQuery().getQueryString()));
        }
        if (this.isValidateJql(request) && (messageSet = this.searchService.validateQuery(loggedInUser, searchRequest.getQuery(), searchRequest.getId())).hasAnyErrors()) {
            response.sendError(400, (String)messageSet.getErrorMessages().iterator().next());
            return;
        }
        try {
            resultCount = this.searchService.searchCount(loggedInUser, searchRequest.getQuery());
        }
        catch (ClauseTooComplexSearchException e) {
            response.sendError(400, this.createTooComplexError(e.getClause()));
            return;
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> searchCountParam = new HashMap<String, String>();
        searchCountParam.put("searchCount", String.valueOf(resultCount));
        PagerFilter pagerFilter = this.getPagerFilter(request);
        SearchRequestParamsImpl searchRequestParams = new SearchRequestParamsImpl(request.getSession(true), pagerFilter, searchCountParam, issueViewFieldParams, request.getHeader("USER-AGENT"), moduleDescriptor.getFileExtension());
        if (Boolean.valueOf(request.getParameter("returnMax")).booleanValue()) {
            searchRequestParams.setReturnMax(true);
            pagerFilter.setMax(Math.min(pagerFilter.getMax(), this.getMaxAllowed()));
        }
        if (!moduleDescriptor.isExcludeFromLimitFilter() && !(result = this.requestAuthorizer.isSearchRequestAuthorized(loggedInUser, searchRequest, (SearchRequestParams)searchRequestParams)).isOK()) {
            response.sendError(403, result.getReason());
            return;
        }
        if (!moduleDescriptor.getCondition().shouldDisplay((Map)ImmutableMap.of())) {
            response.sendError(404);
            return;
        }
        if (!"true".equalsIgnoreCase(request.getParameter("noResponseHeaders"))) {
            response.setContentType(moduleDescriptor.getContentType() + ";charset=" + ComponentAccessor.getApplicationProperties().getEncoding());
            view.writeHeaders(searchRequest, (RequestHeaders)new HttpRequestHeaders(response), (SearchRequestParams)searchRequestParams);
        }
        response.getWriter().flush();
        BufferedWriter writer = new BufferedWriter(response.getWriter());
        char csvDelimiter = this.resolveCsvDelimiter(request);
        searchRequest.setCsvDelimiter(csvDelimiter);
        try {
            view.writeSearchResults(searchRequest, (SearchRequestParams)searchRequestParams, (Writer)writer);
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        ((Writer)writer).flush();
        String jqlString = searchRequest.getQuery().getQueryString();
        boolean triggeredByApplication = false;
        if (RequestAnnotations.isOAuthRequest((HttpServletRequest)request)) {
            triggeredByApplication = StringUtils.isNotBlank((CharSequence)RequestAnnotations.getOAuthConsumerKey((HttpServletRequest)request));
        }
        this.sendAnalyticEvent(moduleDescriptor.getKey(), csvDelimiter, jqlString, resultCount, triggeredByApplication);
    }

    private char resolveCsvDelimiter(HttpServletRequest request) {
        String parameter = request.getParameter("delimiter");
        return this.delimiterResolver.resolve(parameter);
    }

    protected int getMaxAllowed() {
        String defaultMax = this.applicationProperties.getDefaultBackedString("jira.search.views.max.limit");
        int retVal = Integer.MAX_VALUE;
        try {
            if (StringUtils.isNotBlank((CharSequence)defaultMax)) {
                retVal = Integer.valueOf(defaultMax);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot get search result restriction limit for: '" + defaultMax + "' key=jira.search.views.max.limit");
        }
        return retVal;
    }

    protected SearchRequestService getSearchRequestService() {
        return (SearchRequestService)ComponentAccessor.getComponent(SearchRequestService.class);
    }

    private void sendAnalyticEvent(String key, char csvDelimiter, String jqlString, long issuesTotal, boolean triggeredByApplication) {
        ExportEvent event = ExportEvent.builder().withKey(key).withDelimiter(String.valueOf(csvDelimiter)).withJqlString(jqlString).withIssuesTotal(issuesTotal).withTriggeredByApplication(triggeredByApplication).build();
        this.eventPublisher.publish((Object)event);
    }

    private String createTooComplexError(Clause clause) throws IOException {
        if (clause instanceof TerminalClause) {
            return this.i18n.getInstance(this.authenticationContext.getLocale()).getText("search.request.clause.too.complex", this.jqlStringSupport.generateJqlString(clause));
        }
        return this.i18n.getInstance(this.authenticationContext.getLocale()).getText("search.request.clause.query.complex");
    }

    SearchRequestFactory getSearchRequestFactory() {
        return (SearchRequestFactory)ComponentAccessor.getComponent(SearchRequestFactory.class);
    }

    private String getJqlQueryString(Map<String, String[]> parameters) {
        String[] jqlArr = parameters.get("jql");
        if (jqlArr != null && jqlArr.length == 1) {
            return jqlArr[0];
        }
        String[] jqlClassicalArr = parameters.get("jqlQuery");
        if (jqlClassicalArr != null && jqlClassicalArr.length == 1) {
            return jqlClassicalArr[0];
        }
        return null;
    }

    private void writeDummyXMLResponse(HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n\n");
        sb.append("<!--  RSS generated by JIRA ").append(this.buildUtilsInfo.getVersion()).append(" at ").append(this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.RSS_RFC822_DATE_TIME).withSystemZone().format(new Date())).append(" -->\n");
        sb.append("<rss version=\"0.92\">\n");
        sb.append("<channel>\n");
        sb.append("\t<title>").append(XMLUtils.escape((String)this.applicationProperties.getString("jira.title"))).append("</title>\n");
        sb.append("\t<link>").append(XMLUtils.escape((String)baseUrl)).append("</link>\n");
        sb.append("\t<description>").append(XMLUtils.escape((String)this.i18n.getInstance(this.authenticationContext.getLocale()).getText("issue.views.xml.some.desc"))).append("</description>\n");
        String rssLocale = RssViewUtils.getRssLocale(this.authenticationContext.getLocale());
        if (rssLocale != null) {
            sb.append("\t<language>").append(rssLocale).append("</language>\n");
        }
        sb.append("<build-info>");
        sb.append("\t<version>").append(XMLUtils.escape((String)this.buildUtilsInfo.getVersion())).append("</version>");
        sb.append("\t<build-number>").append(XMLUtils.escape((String)this.buildUtilsInfo.getCurrentBuildNumber())).append("</build-number>");
        sb.append("\t<build-date>").append(XMLUtils.escape((String)new SimpleDateFormat("dd-MM-yyyy").format(this.buildUtilsInfo.getCurrentBuildDate()))).append("</build-date>");
        sb.append("</build-info>");
        sb.append("</channel>\n");
        sb.append("</rss>\n");
        PrintWriter out = response.getWriter();
        out.write(sb.toString());
        out.flush();
    }

    private void loadJsp(HttpServletRequest request, HttpServletResponse response, String jspPage) throws IOException {
        try {
            request.getRequestDispatcher(jspPage).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not load java server page", e);
        }
    }

    private void redirectToBasicAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer requestUrl = request.getRequestURL();
        if (requestUrl != null && StringUtils.isNotEmpty((CharSequence)requestUrl.toString())) {
            Object requestUrlString = requestUrl.toString();
            requestUrlString = ((String)requestUrlString).indexOf(63) == -1 ? (String)requestUrlString + "?os_authType=basic" : (String)requestUrlString + "&os_authType=basic";
            response.setHeader("Location", (String)requestUrlString);
            response.setStatus(301);
        } else {
            response.sendError(500, this.i18n.getInstance(this.authenticationContext.getLocale()).getText("search.request.invalid.permission"));
        }
    }

    protected PagerFilter getPagerFilter(HttpServletRequest request) {
        String tempMax = request.getParameter("tempMax");
        PagerFilter pager = null;
        if (StringUtils.isNotEmpty((CharSequence)tempMax)) {
            try {
                int max = Integer.parseInt(tempMax);
                pager = new PagerFilter(max);
            }
            catch (NumberFormatException max) {
                // empty catch block
            }
        }
        if (pager == null) {
            pager = PagerFilter.getUnlimitedFilter();
        }
        String startParam = request.getParameter("pager/start");
        int start = 0;
        if (StringUtils.isNotEmpty((CharSequence)startParam)) {
            try {
                start = Integer.parseInt(startParam);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        pager.setStart(start);
        return pager;
    }

    private boolean isValidateJql(HttpServletRequest request) {
        String[] validateParams;
        Map requestParameters = request.getParameterMap();
        if (requestParameters.containsKey(VALIDATE_PARAM) && (validateParams = (String[])requestParameters.get(VALIDATE_PARAM)) != null && validateParams.length > 0) {
            return Boolean.valueOf(validateParams[0]);
        }
        return true;
    }
}

