/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestInfo;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestURLHandler;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestViewModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.plugin.webfragment.descriptors.ConditionDescriptorFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import org.apache.commons.lang3.StringUtils;

public class SearchRequestViewModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<SearchRequestView>
implements SearchRequestViewModuleDescriptor {
    private String contentType;
    private String fileExtension;
    private final SearchRequestURLHandler urlHandler;
    private final ConditionDescriptorFactory conditionDescriptorFactory;
    private boolean basicAuthenticationRequired;
    private boolean excludeFromLimitFilter;
    private int order;
    private Condition condition;
    private Element element;

    public SearchRequestViewModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, SearchRequestURLHandler urlHandler, ModuleFactory moduleFactory, ConditionDescriptorFactory conditionDescriptorFactory) {
        super(authenticationContext, moduleFactory);
        this.urlHandler = urlHandler;
        this.conditionDescriptorFactory = conditionDescriptorFactory;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.fileExtension = element.attributeValue("fileExtension");
        this.contentType = element.attributeValue("contentType");
        String basicAuthAttribute = element.attributeValue("basicAuthenticationRequired");
        this.basicAuthenticationRequired = basicAuthAttribute != null ? StringUtils.isNotEmpty((CharSequence)basicAuthAttribute) && Boolean.valueOf(this.basicAuthenticationRequired) != false : false;
        String excludeFromLimitFilterAttr = element.attributeValue("excludeFromLimitFilter");
        if (excludeFromLimitFilterAttr != null) {
            this.excludeFromLimitFilter = Boolean.valueOf(excludeFromLimitFilterAttr);
        }
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
        this.element = element;
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(SearchRequestView.class);
        this.condition = this.conditionDescriptorFactory.retrieveCondition(this.plugin, this.element);
    }

    @Override
    public void disabled() {
        this.condition = null;
        super.disabled();
    }

    public SearchRequestView getSearchRequestView() {
        return (SearchRequestView)this.getModule();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getURLWithoutContextPath(SearchRequest searchRequest) {
        return this.urlHandler.getURLWithoutContextPath(this, new SearchRequestInfo(searchRequest));
    }

    public String getURLWithoutContextPath(SearchRequestInfo searchRequestInfo) {
        return this.urlHandler.getURLWithoutContextPath(this, searchRequestInfo);
    }

    public boolean isBasicAuthenticationRequired() {
        return this.basicAuthenticationRequired;
    }

    public boolean isExcludeFromLimitFilter() {
        return this.excludeFromLimitFilter;
    }

    public int getOrder() {
        return this.order;
    }

    public Condition getCondition() {
        return this.condition;
    }
}

