/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview.auth;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.plugin.searchrequestview.auth.Authorizer;
import com.atlassian.jira.plugin.searchrequestview.auth.SearchResultSizeAuthorizer;
import com.atlassian.jira.plugin.searchrequestview.auth.UserAuthorizer;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizerImpl
implements Authorizer {
    private static final Logger log = LoggerFactory.getLogger(AuthorizerImpl.class);
    private final SearchService searchService;
    private final ApplicationProperties properties;
    private final GroupManager groupManager;

    public AuthorizerImpl(SearchService searchService, ApplicationProperties properties, GroupManager groupManager) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService, (Object)"searchService");
        this.properties = (ApplicationProperties)Preconditions.checkNotNull((Object)properties, (Object)"properties");
        this.groupManager = (GroupManager)Preconditions.checkNotNull((Object)groupManager, (Object)"userManager");
    }

    @VisibleForTesting
    Authorizer getDelegate() {
        boolean noLimit;
        long limit = this.getResultLimit();
        boolean bl = noLimit = limit < 0L;
        if (noLimit) {
            return Authorizer.ALWAYS;
        }
        Object authorizer = new SearchResultSizeAuthorizer(this.searchService, limit, Authorizer.ALWAYS);
        String allowedGroupName = this.properties.getDefaultBackedString("jira.search.views.max.unlimited.group");
        if (StringUtils.isNotBlank((CharSequence)allowedGroupName)) {
            Group allowedGroup = this.groupManager.getGroup(allowedGroupName);
            if (allowedGroup == null) {
                log.error("The group: '" + allowedGroupName + "' specified as the property: 'jira.search.views.max.unlimited.group' does not exist. Cannot setup a group to bypass search result filtering");
            } else {
                authorizer = new UserAuthorizer(allowedGroup, (Authorizer)authorizer, this.groupManager);
            }
        }
        return authorizer;
    }

    public Authorizer.Result isSearchRequestAuthorized(ApplicationUser user, SearchRequest searchRequest, SearchRequestParams params) {
        return this.getDelegate().isSearchRequestAuthorized(user, searchRequest, params);
    }

    private long getResultLimit() {
        String defaultMax = this.properties.getDefaultBackedString("jira.search.views.max.limit");
        try {
            if (StringUtils.isBlank((CharSequence)defaultMax)) {
                return -1L;
            }
            return Long.valueOf(defaultMax).intValue();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot get search result restriction limit for: '" + defaultMax + "' key=jira.search.views.max.limit");
        }
    }
}

