/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.annotated.AnnotatedSecurityChecker;
import com.atlassian.jira.security.annotated.AnnotatedSecurityEnabledCheck;
import com.atlassian.jira.security.annotated.SecureDefaultsStats;
import com.atlassian.jira.servlet.ServletRequestUtil;
import com.atlassian.plugin.servlet.DelegatingPluginServlet;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.servlet.util.RequestUtil;
import com.atlassian.sal.core.permission.AccessType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ServletModuleContainerServlet
extends com.atlassian.plugin.servlet.ServletModuleContainerServlet {
    private static final Logger log = LoggerFactory.getLogger(ServletModuleContainerServlet.class);
    private static final Map<String, AccessType> SERVLET_TO_ACCESS_TYPE_SHORTCUT = new ImmutableMap.Builder().put((Object)"Toolbar Servlet", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"Multi Path Servlet", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"Servlet with translation key", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"Jira Mobile Servlet", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"Wallboard", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"BootstrapScriptServlet", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"TestServletModuleContainerServlet.mapHasPriorityOverTheAnnotation", (Object)AccessType.SYSTEM_ADMIN_ONLY).build();
    private final AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck;
    private final Supplier<AnnotatedSecurityChecker> securityCheckerSupplier;
    private ServletConfig servletConfig;

    public ServletModuleContainerServlet() {
        this(new AnnotatedSecurityEnabledCheck(), ServletRequestUtil::getSecurityChecker);
    }

    @VisibleForTesting
    ServletModuleContainerServlet(AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck, Supplier<AnnotatedSecurityChecker> securityCheckerSupplier) {
        this.annotatedSecurityEnabledCheck = annotatedSecurityEnabledCheck;
        this.securityCheckerSupplier = securityCheckerSupplier;
    }

    protected ServletModuleManager getServletModuleManager() {
        return (ServletModuleManager)ComponentAccessor.getComponent(ServletModuleManager.class);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.annotatedSecurityEnabledCheck.isAnnotatedSecurityDisabled()) {
            super.service(request, response);
            return;
        }
        ServletNameAndClass servletNameAndClass = this.getServletDetails(request);
        if (servletNameAndClass == null) {
            super.service(request, response);
            return;
        }
        String servletName = servletNameAndClass.name;
        AccessType accessType = SERVLET_TO_ACCESS_TYPE_SHORTCUT.get(servletName);
        if (accessType == null) {
            accessType = this.getAccessType(request, servletNameAndClass.clazz);
        }
        if (this.securityCheckerSupplier.get().isAllowedFor(accessType)) {
            ServletRequestUtil.clearRedirectAttributes(request);
            ComponentAccessor.getComponentSafely(SecureDefaultsStats.class).ifPresent(stats -> stats.pluginServletAllowed(stopwatch.elapsed(TimeUnit.MICROSECONDS)));
            super.service(request, response);
        } else {
            if (log.isDebugEnabled()) {
                if (accessType == AccessType.EMPTY) {
                    log.debug("{} Servlet {}, class {}, method {} is not allowed for the current user. The servlet has no security annotation and so we use the default value. Redirecting to login screen.", new Object[]{"[SECURITY ANNOTATION CHECK]", servletName, servletNameAndClass.clazz.getName(), ServletRequestUtil.getMethodName(request)});
                } else {
                    log.debug("{} Servlet {}, class {}, method {} is not allowed for the current user. The servlet has accessType={}. Redirecting to login screen.", new Object[]{"[SECURITY ANNOTATION CHECK]", servletName, servletNameAndClass.clazz.getName(), ServletRequestUtil.getMethodName(request), accessType});
                }
            }
            ServletRequestUtil.redirectToLoginScreen(request, response, accessType);
            ComponentAccessor.getComponentSafely(SecureDefaultsStats.class).ifPresent(stats -> stats.pluginServletNotAllowed(stopwatch.elapsed(TimeUnit.MICROSECONDS)));
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
    }

    private AccessType getAccessType(HttpServletRequest request, Class<? extends HttpServlet> servletClass) {
        return AccessType.getAccessType(servletClass, (String)ServletRequestUtil.getMethodName(request), (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
    }

    @Nullable
    private ServletNameAndClass getServletDetails(HttpServletRequest request) throws ServletException {
        HttpServlet delegatingServlet = this.getServletModuleManager().getServlet(RequestUtil.getPathInfo((HttpServletRequest)request), this.servletConfig);
        if (delegatingServlet == null) {
            return null;
        }
        if (delegatingServlet instanceof DelegatingPluginServlet) {
            ServletModuleDescriptor moduleDescriptor = ((DelegatingPluginServlet)delegatingServlet).getModuleDescriptor();
            return new ServletNameAndClass(moduleDescriptor.getDisplayName(), moduleDescriptor.getModuleClass());
        }
        throw new IllegalStateException("Servlet is not an instance of DelegatingPluginServlet, but of " + delegatingServlet.getClass().getName());
    }

    private static final class ServletNameAndClass {
        private final String name;
        private final Class<? extends HttpServlet> clazz;

        public ServletNameAndClass(String name, Class<? extends HttpServlet> clazz) {
            this.name = name;
            this.clazz = clazz;
        }
    }
}

