/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileLinkUserFormat
implements UserFormat {
    public static final String TYPE = "profileLink";
    private static final Logger log = LoggerFactory.getLogger(ProfileLinkUserFormat.class);
    private final AvatarService avatarService;
    private final I18nHelper i18nHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserFormatModuleDescriptor moduleDescriptor;
    private final UserKeyService userKeyService;
    private final UserUtil userUtil;
    private final UserManager userManager;

    public ProfileLinkUserFormat(AvatarService avatarService, I18nHelper i18nHelper, JiraAuthenticationContext jiraAuthenticationContext, UserFormatModuleDescriptor moduleDescriptor, UserKeyService userKeyService, UserUtil userUtil, UserManager userManager) {
        this.avatarService = avatarService;
        this.i18nHelper = i18nHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.moduleDescriptor = moduleDescriptor;
        this.userKeyService = userKeyService;
        this.userUtil = userUtil;
        this.userManager = userManager;
    }

    @HtmlSafe
    public String format(String key, String id) {
        Map<String, Object> params = this.getInitialParams(key, id);
        return this.moduleDescriptor.getHtml("view", params);
    }

    @HtmlSafe
    public String format(String key, String id, Map<String, Object> params) {
        Map<String, Object> velocityParams = this.getInitialParams(key, id);
        velocityParams.putAll(params);
        return this.moduleDescriptor.getHtml("view", velocityParams);
    }

    private Map<String, Object> getInitialParams(String key, String id) {
        ApplicationUser user = null;
        String username = null;
        Object fullName = null;
        if (key != null) {
            user = this.userManager.getUserByKey(key);
            if (user == null) {
                username = this.userKeyService.getUsernameForKey(key);
                if (username == null) {
                    username = key;
                }
                fullName = username;
            } else {
                username = user.getUsername();
                fullName = this.userUtil.getDisplayableNameSafely(user);
                if (!user.isActive()) {
                    fullName = (String)fullName + " (" + this.jiraAuthenticationContext.getI18nHelper().getText("admin.common.words.inactive") + ")";
                }
            }
        }
        Avatar.Size avatarSize = Avatar.Size.SMALL;
        String avatarURL = this.avatarService.getAvatarURL(this.jiraAuthenticationContext.getUser(), user, avatarSize).toString();
        return MapBuilder.newBuilder().add((Object)"avatarURL", (Object)avatarURL).add((Object)"avatarSize", (Object)avatarSize.getParam()).add((Object)"lazyLoadImage", (Object)true).add((Object)"defaultFullName", (Object)this.i18nHelper.getText("common.words.anonymous")).add((Object)"fullname", fullName).add((Object)"id", (Object)id).add((Object)"user", (Object)user).add((Object)"username", (Object)username).add((Object)"soyRenderer", (Object)this.getSoyRenderer()).toMutableMap();
    }

    public SoyTemplateRenderer getSoyRenderer() {
        return ((SoyTemplateRendererProvider)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRendererProvider.class)).getRenderer();
    }
}

