/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Map;

public class SimpleProfileLinkUserFormat
implements UserFormat {
    public static final String TYPE = "profileLink";
    private final I18nHelper i18nHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserFormatModuleDescriptor moduleDescriptor;
    private final UserKeyService userKeyService;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final BaseUrl baseUrl;

    public SimpleProfileLinkUserFormat(I18nHelper i18nHelper, JiraAuthenticationContext jiraAuthenticationContext, UserFormatModuleDescriptor moduleDescriptor, UserKeyService userKeyService, UserUtil userUtil, UserManager userManager, BaseUrl baseUrl) {
        this.i18nHelper = i18nHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.moduleDescriptor = moduleDescriptor;
        this.userKeyService = userKeyService;
        this.userUtil = userUtil;
        this.userManager = userManager;
        this.baseUrl = baseUrl;
    }

    @HtmlSafe
    public String format(String key, String id) {
        Map<String, Object> params = this.getInitialParams(key, id);
        return this.moduleDescriptor.getHtml("view", params);
    }

    @HtmlSafe
    public String format(String key, String id, Map<String, Object> params) {
        Map<String, Object> velocityParams = this.getInitialParams(key, id);
        velocityParams.putAll(params);
        return this.moduleDescriptor.getHtml("view", velocityParams);
    }

    private Map<String, Object> getInitialParams(String key, String id) {
        ApplicationUser user = null;
        String username = null;
        Object fullName = null;
        if (key != null) {
            user = this.userManager.getUserByKey(key);
            if (user == null) {
                username = this.userKeyService.getUsernameForKey(key);
                if (username == null) {
                    username = key;
                }
                fullName = username;
            } else {
                username = user.getUsername();
                fullName = this.userUtil.getDisplayableNameSafely(user);
                if (!user.isActive()) {
                    fullName = (String)fullName + " (" + this.jiraAuthenticationContext.getI18nHelper().getText("admin.common.words.inactive") + ")";
                }
            }
        }
        return MapBuilder.newBuilder().add((Object)"defaultFullName", (Object)this.i18nHelper.getText("common.words.anonymous")).add((Object)"fullName", fullName).add((Object)"id", (Object)id).add((Object)"user", (Object)user).add((Object)"username", (Object)username).add((Object)"baseUrl", (Object)this.baseUrl.getBaseUrl()).toMutableMap();
    }
}

