/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.descriptors;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;

public class DefaultSimpleLinkFactoryModuleDescriptor
extends AbstractJiraModuleDescriptor<SimpleLinkFactory>
implements SimpleLinkFactoryModuleDescriptor {
    private int weight;
    private boolean shouldBeLazy = false;
    private String section;

    public DefaultSimpleLinkFactoryModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = 1000;
        try {
            this.weight = Integer.parseInt(element.attributeValue("weight"));
        }
        catch (NumberFormatException e) {
            throw new PluginParseException(String.format("The plugin module: %s specified a weight attribute that is not an integer.", this.getCompleteKey()), (Throwable)e);
        }
        this.shouldBeLazy = Boolean.valueOf(element.attributeValue("lazy"));
        this.section = element.attributeValue("section");
    }

    public boolean shouldBeLazy() {
        return this.shouldBeLazy;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getSection() {
        return this.section;
    }
}

