/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.PluginResourceLocatorImpl;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManagerImpl;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.util.LinkedHashMap;
import java.util.Map;

public class JiraWebResourceManagerImpl
extends WebResourceManagerImpl
implements JiraWebResourceManager {
    private static final String REQUEST_CACHE_METADATA_KEY = "jira.metadata.map";

    public JiraWebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration) {
        super(((PluginResourceLocatorImpl)pluginResourceLocator).getGlobals(), webResourceIntegration, webResourceUrlProvider, batchingConfiguration);
    }

    public boolean putMetadata(String key, String value) {
        LinkedHashMap<String, String> metadataMap = (LinkedHashMap<String, String>)this.cache().get(REQUEST_CACHE_METADATA_KEY);
        if (metadataMap == null) {
            metadataMap = new LinkedHashMap<String, String>();
            this.cache().put(REQUEST_CACHE_METADATA_KEY, metadataMap);
        }
        metadataMap.put(key, value);
        return true;
    }

    public Map<String, String> getMetadata() {
        Map metadataMap = (Map)this.cache().remove(REQUEST_CACHE_METADATA_KEY);
        if (metadataMap == null) {
            metadataMap = MapBuilder.emptyMap();
        }
        return metadataMap;
    }

    private Map<String, Object> cache() {
        return this.webResourceIntegration.getRequestCache();
    }
}

