/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webwork;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.webwork.AutowireCapableWebworkActionRegistry;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.internal.module.Dom4jDelegatingElement;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import electric.xml.Document;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.NodeList;
import webwork.config.ConfigurationInterface;
import webwork.config.WebworkConfigurationNotFoundException;
import webwork.config.util.XMLConfigurationReader;

public class WebworkModuleDescriptor
extends AbstractJiraModuleDescriptor<Void>
implements ConfigurationInterface {
    public static final Logger log = Logger.getLogger(WebworkModuleDescriptor.class);
    private XMLConfigurationReader configurationReader;
    private final AutowireCapableWebworkActionRegistry autowireCapabaleWebworkActionRegistry;
    private org.w3c.dom.Element actionElement;
    private Document webworkDocument;

    public WebworkModuleDescriptor(JiraAuthenticationContext authenticationContext, AutowireCapableWebworkActionRegistry autowireCapabaleWebworkActionRegistry, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
        this.autowireCapabaleWebworkActionRegistry = autowireCapabaleWebworkActionRegistry;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        try {
            this.webworkDocument = new Document(((Dom4jDelegatingElement)element).getDelegate().asXML());
            electric.xml.Element root = this.webworkDocument.getRoot();
            NodeList actionsNodes = root.getElementsByTagName("actions");
            if (actionsNodes.getLength() != 1) {
                throw new PluginParseException(root.getName() + " module " + (String)(root.hasAttribute("key") ? "with key='" + root.getAttribute("key") + "' " : "") + (String)(actionsNodes.getLength() == 0 ? "requires an <actions> block." : "can have only 1 <actions> block (" + actionsNodes.getLength() + " found)."));
            }
            this.actionElement = (org.w3c.dom.Element)actionsNodes.item(0);
            this.configurationReader = new XMLConfigurationReader(this.actionElement, this.getCompleteKey());
        }
        catch (Exception xmlActionConfigurationParsingException) {
            log.error((Object)String.format("Unable to parse the webwork plugin module: '%s' due to invalid XML.", this.getCompleteKey()), (Throwable)xmlActionConfigurationParsingException);
        }
    }

    @Override
    public void disabled() {
        super.disabled();
        this.autowireCapabaleWebworkActionRegistry.unregisterPluginModule((ModuleDescriptor<?>)this);
    }

    @Override
    public void enabled() {
        super.enabled();
        if (this.getPlugin() instanceof ContainerManagedPlugin) {
            this.registerActionClassNames();
        }
    }

    @Override
    public Void getModule() {
        throw new IllegalArgumentException("There is no module for WebworkModuleDescriptor.  Access the Descriptor directly");
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        Object actionMapping = this.configurationReader.getActionMapping(aName);
        if (actionMapping == null) {
            throw new WebworkConfigurationNotFoundException(((Object)((Object)this)).getClass(), "No such setting", aName);
        }
        return actionMapping;
    }

    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This configuration does not support updating a setting");
    }

    public Iterator listImpl() {
        return this.configurationReader.getActionMappingNames().iterator();
    }

    public Document getWebworkDocument() {
        return this.webworkDocument;
    }

    private void registerActionClassNames() {
        NodeList actions = this.actionElement.getElementsByTagName("action");
        int length = actions.getLength();
        for (int i = 0; i < length; ++i) {
            org.w3c.dom.Element action = (org.w3c.dom.Element)actions.item(i);
            String actionName = action.getAttribute("name");
            if (!StringUtils.isNotEmpty((CharSequence)actionName)) continue;
            String className = StringUtils.substringAfterLast((String)actionName, (String)".");
            if (StringUtils.isEmpty((CharSequence)className)) {
                className = actionName;
            }
            this.autowireCapabaleWebworkActionRegistry.registerAction(className, (ModuleDescriptor<?>)this);
        }
    }
}

