/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginConditionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.OSWorkflowConfigurator;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.module.ModuleFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.Validate;

public class WorkflowConditionModuleDescriptor
extends AbstractWorkflowModuleDescriptor<WorkflowPluginConditionFactory> {
    public WorkflowConditionModuleDescriptor(JiraAuthenticationContext authenticationContext, OSWorkflowConfigurator workflowConfigurator, ComponentClassManager componentClassManager, ModuleFactory moduleFactory) {
        super(authenticationContext, workflowConfigurator, componentClassManager, moduleFactory);
    }

    @Override
    protected String getParameterName() {
        return "condition-class";
    }

    @Override
    public String getHtml(String resourceName, AbstractDescriptor descriptor) {
        if (descriptor != null && !(descriptor instanceof ConditionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a ConditionDescriptor");
        }
        ConditionDescriptor conditionDescriptor = (ConditionDescriptor)descriptor;
        WorkflowPluginConditionFactory workflowConditionFactory = (WorkflowPluginConditionFactory)this.getModule();
        return super.getHtml(resourceName, workflowConditionFactory.getVelocityParams(resourceName, (AbstractDescriptor)conditionDescriptor));
    }

    @Override
    public boolean isOrderable() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    @Override
    public boolean isAddable(String actionType) {
        return true;
    }

    @Override
    public AbstractWorkflowModuleDescriptor.PluginTypeResolver createPluginTypeResolver() {
        return new SafeConditionPluginTypeResolver();
    }

    class SafeConditionPluginTypeResolver
    extends AbstractWorkflowModuleDescriptor.PluginTypeResolver {
        private final AbstractWorkflowModuleDescriptor.PluginTypeResolver pluginTypeResolver;

        SafeConditionPluginTypeResolver() {
            super(WorkflowConditionModuleDescriptor.this);
            this.pluginTypeResolver = new AbstractWorkflowModuleDescriptor.PluginTypeResolver(WorkflowConditionModuleDescriptor.this);
        }

        @Override
        protected Object loadObject(final String clazz) {
            return SafePluginPointAccess.call((Callable)new Callable<Condition>(){

                @Override
                public Condition call() throws Exception {
                    Condition condition = (Condition)SafeConditionPluginTypeResolver.this.pluginTypeResolver.loadObject(clazz);
                    return new SafeConditionPlugin(condition);
                }
            }).getOrNull();
        }
    }

    static class SafeConditionPlugin
    implements Condition {
        private Condition condition;

        SafeConditionPlugin(Condition condition) {
            Validate.notNull((Object)condition);
            this.condition = condition;
        }

        public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
            try {
                return this.condition.passesCondition(transientVars, args, ps);
            }
            catch (Throwable throwable) {
                SafePluginPointAccess.handleException((Throwable)throwable);
                return false;
            }
        }
    }
}

