/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.OSWorkflowConfigurator;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class WorkflowFunctionModuleDescriptor
extends AbstractWorkflowModuleDescriptor<WorkflowPluginFunctionFactory> {
    private boolean orderable = true;
    private boolean unique = false;
    private boolean deletable = true;
    private Collection<String> addableActionTypes = JiraWorkflow.ACTION_TYPE_ALL;
    private Integer weight = null;
    private boolean isDefault = false;
    public static final String ACTION_TYPE_NON_INITIAL = "non-initial";

    public WorkflowFunctionModuleDescriptor(JiraAuthenticationContext authenticationContext, OSWorkflowConfigurator workflowConfigurator, ComponentClassManager componentClassManager, ModuleFactory moduleFactory) {
        super(authenticationContext, workflowConfigurator, componentClassManager, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        String paramValue = this.getParamValue(element, "orderable");
        if (paramValue != null) {
            this.orderable = Boolean.valueOf(paramValue);
        }
        if ((paramValue = this.getParamValue(element, "unique")) != null) {
            this.unique = Boolean.valueOf(paramValue);
        }
        if ((paramValue = this.getParamValue(element, "deletable")) != null) {
            this.deletable = Boolean.valueOf(paramValue);
        }
        if ((paramValue = this.getParamValue(element, "addable")) != null) {
            String[] addableParams = StringUtils.split((String)paramValue, (String)",");
            this.addableActionTypes = new HashSet<String>();
            for (String addableParam : addableParams) {
                if (ACTION_TYPE_NON_INITIAL.equals(addableParam)) {
                    this.addableActionTypes.add("global");
                    this.addableActionTypes.add("common");
                    this.addableActionTypes.add("ordinary");
                    continue;
                }
                if (JiraWorkflow.ACTION_TYPE_ALL.contains(addableParam)) {
                    this.addableActionTypes.add(addableParam);
                    continue;
                }
                throw new PluginParseException("Invalid addable parameter '" + addableParam + "'.");
            }
        }
        if ((paramValue = this.getParamValue(element, "weight")) != null) {
            if (this.unique) {
                this.weight = Integer.valueOf(paramValue);
            } else {
                throw new PluginParseException("Function descriptors with 'weight' must be 'unique'.");
            }
        }
        if ((paramValue = this.getParamValue(element, "default")) != null) {
            this.isDefault = Boolean.valueOf(paramValue);
        }
    }

    @Override
    protected String getParameterName() {
        return "function-class";
    }

    @Override
    public String getHtml(String resourceName, AbstractDescriptor descriptor) {
        if (descriptor != null && !(descriptor instanceof FunctionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor");
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        WorkflowPluginFunctionFactory workflowPluginFunctionFactory = (WorkflowPluginFunctionFactory)this.getModule();
        return super.getHtml(resourceName, workflowPluginFunctionFactory.getVelocityParams(resourceName, (AbstractDescriptor)functionDescriptor));
    }

    @Override
    public boolean isOrderable() {
        return this.orderable;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isDeletable() {
        return this.deletable;
    }

    @Override
    public boolean isAddable(String actionType) {
        return this.addableActionTypes.contains(actionType);
    }

    public Integer getWeight() {
        return this.weight;
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

