/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.UserKeyInPortalPageFKChangedEvent;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@EventComponent
public class CachingPortalPageStore
implements PortalPageStore {
    private final PortalPageStore delegateStore;
    private final Cache<String, List<Long>> cacheByUser;
    private final Cache<Long, Optional<PortalPage>> cacheById;
    private volatile Long systemDefaultPortalPageId = null;

    public CachingPortalPageStore(PortalPageStore delegateStore, CacheManager cacheManager) {
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
        this.cacheByUser = cacheManager.getCache(this.getClass().getName() + ".cacheByUser", this::loadByUser, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheById = cacheManager.getCache(this.getClass().getName() + ".cacheById", this::loadById, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.flush();
    }

    @EventListener
    public void onUserKeyInPortalPageFKChangedEvent(UserKeyInPortalPageFKChangedEvent event) {
        this.flush();
    }

    @Override
    public EnclosedIterable<PortalPage> get(SharedEntityAccessor.RetrievalDescriptor ids) {
        return this.delegateStore.get(ids);
    }

    @Override
    public EnclosedIterable<PortalPage> getAll() {
        return this.delegateStore.getAll();
    }

    @Override
    public PortalPage getSystemDefaultPortalPage() {
        PortalPage page;
        if (this.systemDefaultPortalPageId == null && (page = this.delegateStore.getSystemDefaultPortalPage()) != null) {
            this.systemDefaultPortalPageId = page.getId();
        }
        if (this.systemDefaultPortalPageId != null) {
            return this.getPortalPage(this.systemDefaultPortalPageId);
        }
        return null;
    }

    @Override
    public Collection<PortalPage> getAllOwnedPortalPages(@Nonnull ApplicationUser owner) {
        Assertions.notNull((String)"owner", (Object)owner);
        return this.getAllOwnedPortalPages(owner.getKey());
    }

    @Override
    public Collection<PortalPage> getAllOwnedPortalPages(@Nonnull String userKey) {
        return ((List)this.cacheByUser.get((Object)((String)Assertions.notNull((String)"userKey", (Object)userKey)))).stream().map(this::getPortalPage).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public PortalPage getPortalPageByOwnerAndName(ApplicationUser owner, String portalPageName) {
        return this.delegateStore.getPortalPageByOwnerAndName(owner, portalPageName);
    }

    @Override
    public PortalPage getPortalPage(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        return this.copyPortalPage(((Optional)this.cacheById.get((Object)portalPageId)).orElse(null));
    }

    @Override
    public PortalPage create(PortalPage portalPage) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"portalPage.name", (Object)portalPage.getName());
        Assertions.notNull((String)"portalPage.owner", (Object)portalPage.getOwner());
        PortalPage returnPage = null;
        try {
            returnPage = this.delegateStore.create(portalPage);
        }
        finally {
            if (returnPage != null) {
                this.cacheByUser.remove((Object)portalPage.getOwner().getKey());
                this.cacheById.remove((Object)returnPage.getId());
            }
        }
        return this.copyPortalPage(returnPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortalPage update(PortalPage portalPage) {
        PortalPage returnPage;
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"portalPage.id", (Object)portalPage.getId());
        ApplicationUser newOwner = portalPage.getOwner();
        if (!portalPage.isSystemDefaultPortalPage()) {
            Assertions.notNull((String)"portalPage.owner", (Object)newOwner);
        }
        PortalPage oldPortalPage = null;
        try {
            oldPortalPage = this.delegateStore.getPortalPage(portalPage.getId());
            returnPage = this.delegateStore.update(portalPage);
        }
        finally {
            this.cacheById.remove((Object)portalPage.getId());
            if (portalPage.getOwner() != null && (oldPortalPage == null || portalPage.getOwner() != oldPortalPage.getOwner())) {
                this.cacheByUser.remove((Object)portalPage.getOwner().getKey());
            }
            if (oldPortalPage != null && oldPortalPage.getOwner() != portalPage.getOwner()) {
                this.cacheByUser.remove((Object)oldPortalPage.getOwner().getKey());
            }
        }
        return returnPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePortalPageOptimisticLock(Long portalPageId, Long currentVersion) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        Assertions.notNull((String)"currentVersion", (Object)currentVersion);
        try {
            boolean bl = this.delegateStore.updatePortalPageOptimisticLock(portalPageId, currentVersion);
            return bl;
        }
        finally {
            this.cacheById.remove((Object)portalPageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortalPage adjustFavouriteCount(SharedEntity portalPage, int incrementValue) {
        PortalPage returnPage;
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"portalPage.id", (Object)portalPage.getId());
        try {
            returnPage = this.delegateStore.adjustFavouriteCount(portalPage, incrementValue);
        }
        finally {
            this.cacheById.remove((Object)portalPage.getId());
        }
        return returnPage;
    }

    @Override
    public void delete(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        PortalPage oldPage = null;
        try {
            oldPage = this.delegateStore.getPortalPage(portalPageId);
            this.delegateStore.delete(portalPageId);
        }
        finally {
            this.cacheById.remove((Object)portalPageId);
            if (oldPage != null && oldPage.getOwner() != null) {
                this.cacheByUser.remove((Object)oldPage.getOwner().getKey());
            }
        }
    }

    @Override
    public void flush() {
        this.cacheById.removeAll();
        this.cacheByUser.removeAll();
        this.systemDefaultPortalPageId = null;
    }

    private PortalPage copyPortalPage(PortalPage portalPage) {
        return portalPage != null ? new PortalPage.Builder().portalPage(portalPage).build() : null;
    }

    private List<Long> loadByUser(@Nonnull String ownerKey) {
        return (List)this.delegateStore.getAllOwnedPortalPages(ownerKey).stream().map(PortalPage::getId).collect(CollectorsUtil.toImmutableList());
    }

    private Optional<PortalPage> loadById(@Nonnull Long portalPageId) {
        return Optional.ofNullable(this.delegateStore.getPortalPage(portalPageId));
    }
}

